#ifndef MARS_MArrivalTimePix
#define MARS_MArrivalTimePix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MArrivalTimePix : public MParContainer
{
private:
  Float_t fArrivalTimeHiGain;      // mean value of the ArrivalTime
  Float_t fArrivalTimeHiGainError; // error of the mean value of the ArrivalTime
  Float_t fArrivalTimeLoGain;      // mean value of the ArrivalTime
  Float_t fArrivalTimeLoGainError; // error of the mean value of the ArrivalTime

  Byte_t fNumHiGainSaturated;
  Byte_t fNumLoGainSaturated;

public:
    MArrivalTimePix(const char* name=NULL, const char* title=NULL);

    void Clear(Option_t *o="");
    void Print(Option_t *o="") const;

    // Setter
    void SetArrivalTime(Float_t sig, Float_t sigerr);
    void SetArrivalTime(Float_t sighi, Float_t sighierr,Float_t siglo, Float_t sigloerr);
    void SetGainSaturation(Bool_t sat, Byte_t higain, Byte_t logain);

    // Getter
    Float_t GetArrivalTimeHiGain()      const { return fArrivalTimeHiGain; }
    Float_t GetArrivalTimeHiGainError() const { return fArrivalTimeHiGainError; }

    Float_t GetArrivalTimeLoGain()      const { return fArrivalTimeLoGain; }
    Float_t GetArrivalTimeLoGainError() const { return fArrivalTimeLoGainError; }

    Byte_t GetNumHiGainSaturated()      const { return fNumHiGainSaturated; }
    Byte_t GetNumLoGainSaturated()      const { return fNumLoGainSaturated; }

    Bool_t IsLoGainUsed()               const { return fNumHiGainSaturated > 0; }
    Bool_t IsValid()                    const;   

    ClassDef(MArrivalTimePix, 1)	// Storage Container for ArrivalTime information of one pixel
};

#endif
