#ifndef MARS_MEnv
#define MARS_MEnv

#ifndef ROOT_TEnv
#include <TEnv.h>
#endif

#ifndef ROOT_TOrdCollection
#include <TOrdCollection.h>
#endif

class MEnv : public TEnv
{
private:
    TOrdCollection fChecked;

public:
    MEnv(const char *name="") : TEnv(name) { fChecked.SetOwner(); }

    Int_t       GetValue(const char *name, Int_t dflt);
    Double_t    GetValue(const char *name, Double_t dflt);
    const char *GetValue(const char *name, const char *dflt);

    void PrintUntouched() const;

    ClassDef(MEnv, 0) // A slightly more advanced version of TEnv
};
    
#endif

