#ifndef MCAMDISPLAY_H
#define MCAMDISPLAY_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif
#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif

class TBox;
class TText;
class TVirtualPad;
class TClonesArray;

class MGeomCam;
class MHexagon;
class MCerPhotEvt;
class MCerPhotPix;

class MCamDisplay : public TObject
{
private:
    Bool_t         fAutoScale;   //  indicating the autoscale function

    UInt_t         fNumPixels;
    Int_t          fRange;

    TClonesArray  *fPixels;

    Float_t        fMinPhe;      //  The minimal number of Phe
    Float_t        fMaxPhe;      //  The maximum number of Phe

    TClonesArray  *fLegend;
    TClonesArray  *fLegText;

    TVirtualPad *fDrawingPad;

    TBox  *GetBox(Int_t i)  { return (TBox*) fLegend->At(i); }
    TText *GetText(Int_t i) { return (TText*)fLegText->At(i); }

    void SetPixColor(const MCerPhotPix &pix);

    MHexagon &operator[](int i) { return *((MHexagon*)fPixels->At(i)); }

    Int_t GetColor(Float_t wert);

    void UpdateLegend();

public:
    MCamDisplay(MGeomCam *geom);
    ~MCamDisplay();

    void Draw(Option_t *option = "");

    void DrawPhotNum(const MCerPhotEvt *event);
    void DrawPhotErr(const MCerPhotEvt *event);

    void Reset();

    void SetAutoScale(Bool_t input = kTRUE)
    {
        fAutoScale = input;
    }

    ClassDef(MCamDisplay, 0) // Displays the magic camera
};

#endif
