#ifndef MARS_MHCurrents
#define MARS_MHCurrents

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH1
#include <TH1.h>
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

class MCurrents;
class MGeomCam;
class MCamDisplay;

class MHCurrents : public MH
{
private:
    TArrayF      fSum;      // storing the sum
    TArrayF      fRms;      // storing the rms
    Int_t        fEntries;  // number of entries in the histogram
    MGeomCam    *fCam;      // the present geometry
    MCurrents   *fEvt;      //! the current event
    MCamDisplay *fDispl;    //! the camera display

    TH1F         fHist;

public:
    MHCurrents(const char *name=NULL, const char *title=NULL);
    ~MHCurrents();

    void Clear(const Option_t *o="");

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);
    Bool_t Finalize();

    TH1 *GetHistByName(const TString name) { return NULL; }

    const TArrayF &GetSum() const { return fSum; }
    const TArrayF &GetRms() const { return fRms; }

    const TH1F    &GetHist() const { return fHist; }

    void Draw(Option_t *opt="");
    void Paint(Option_t *option="");

    ClassDef(MHCurrents, 1) // Histogram to sum camera events
};

#endif
