#ifndef MARS_MJPedestal
#define MARS_MJPedestal

#ifndef MARS_MJob
#include "MJob.h"
#endif
#ifndef MARS_MPedestalCam
#include "MPedestalCam.h"
#endif
#ifndef MARS_MBadPixelsCam
#include "MBadPixelsCam.h"
#endif

class TCanvas;
class MParList;
class MRunIter;
class MHCamera;
class TH1D;
class MExtractor;
class MEvtLoop;

class MJPedestal : public MJob
{
private:
    static const Double_t fgPedestalMin;
    static const Double_t fgPedestalMax;
    static const Double_t fgPedRmsMin;
    static const Double_t fgPedRmsMax;

    static const Float_t  fgRefPedClosedLids;
    static const Float_t  fgRefPedExtraGalactic;
    static const Float_t  fgRefPedGalactic;

    static const Float_t  fgRefPedRmsClosedLidsInner;
    static const Float_t  fgRefPedRmsExtraGalacticInner;
    static const Float_t  fgRefPedRmsGalacticInner;

    static const Float_t  fgRefPedRmsClosedLidsOuter;
    static const Float_t  fgRefPedRmsExtraGalacticOuter;
    static const Float_t  fgRefPedRmsGalacticOuter;
    
    MRunIter   *fRuns;          // Used pedestal runs
    MExtractor *fExtractor;     // Signal extractor, used to find the nr. of used FADC slices

    MPedestalCam  fPedestalCam; // Created pedestal results
    MBadPixelsCam fBadPixels;   // Bad Pixels

    enum  Display_t { kDataCheckDisplay, kNormalDisplay }; // Possible Display types

    Display_t fDisplayType;     // Chosen Display type    
    
    Bool_t fDataCheck;          // Flag if the data check is run on raw data
    Bool_t fUseData;            // Use data-runs from sequence instead of pedestal runs

    Bool_t ReadPedestalCam();
    Bool_t WriteResult();
    //Bool_t WriteEventloop(MEvtLoop &evtloop) const;

    void   DisplayResult(MParList &plist);
    void   DisplayReferenceLines(MHCamera *cam, const Int_t what) const;
    void   DisplayOutliers(TH1D *hist) const;
    void   FixDataCheckHist(TH1D *hist) const;

    Bool_t CheckEnvLocal();
    
public:
    MJPedestal(const char *name=NULL, const char *title=NULL);

    MPedestalCam &GetPedestalCam()            { return fPedestalCam; }
    const MBadPixelsCam &GetBadPixels() const { return fBadPixels;   }

    const char*  GetOutputFile() const;
    const Bool_t IsDataCheck  () const    { return fDataCheck; }
    const Bool_t IsUseData    () const    { return fUseData;   }    

    Bool_t Process    ();
    Bool_t ProcessFile();

    void SetBadPixels ( const MBadPixelsCam &bad) { bad.Copy(fBadPixels); }
    void SetExtractor (       MExtractor* ext   ) { fExtractor = ext;     }
    void SetInput     (       MRunIter  *iter   ) { fRuns      = iter;    }
    void SetUseData   ( const Bool_t b=kTRUE    ) { fUseData   = b;       }
    void SetDataCheck ( const Bool_t b=kTRUE    ) { fDataCheck = b; 
                        b ? SetDataCheckDisplay() : SetNormalDisplay(); }
    void SetDataCheckDisplay()                    { fDisplayType = kDataCheckDisplay; }
    void SetNormalDisplay   ()                    { fDisplayType = kNormalDisplay;    }
    
    void SetPedContainerName(const char *name) { fPedestalCam.SetName(name); }

    ClassDef(MJPedestal, 0) // Tool to create a pedestal file (MPedestalCam)
};

#endif
