#ifndef HV_H_SEEN
#define HV_H_SEEN

#include <termios.h>		// POSIX terminal control definitions
#include <fcntl.h>		// File control definitions => fcntl() in fcn OpenPort()
#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "HVConfig.h"

#define BAUDRATE B115200

// HV board control registers
#define REG_HV0     0X20
#define REG_HV1     0X28
#define REG_HV2     0X30
#define REG_HV3     0X38
#define REG_RESET   0XF8
#define REG_STATUS  0X80

// HV board status bits
#define BIT_OC0    (1<<3)
#define BIT_OC1    (1<<4)
#define BIT_OC2    (1<<5)
#define BIT_OC3    (1<<6)
#define BIT_RESET  (1<<7)

class ProcessIO;

class HVBoard {
  
   int BoardNumber;
   int fTestModeWrap;
   bool fTestMode;
   class ProcessIO *m;
   
 public:
  
   HVBoard(int, char *, class ProcessIO *);
   ~HVBoard();

   int fDescriptor; 
   bool Overcurrent[NUM_CHAINS];
   bool ResetButton;
   bool WrapOK;
   int LastWrapCount;
   double fTimeOut;      // [s] timeout to return from read 
  
   char *BoardName; 
   int HV[NUM_CHAINS][NUM_CHANNELS];      // HV value in DAC units
   double HVV[NUM_CHAINS][NUM_CHANNELS];  // HV value in volts

   void ClearVoltageArrays();
   int Reset();
   int GetStatus();
   int SetHV(int, unsigned int, int);
   int GetBoardNumber() {return BoardNumber;}
   int Communicate(unsigned char*, int);
   void SetTimeOut(double);
};

#endif
