/***************************************************************************/
/*                                                                         */
/*  Filename: sis3300.h                                                    */
/*                                                                         */
/*  Funktion: headerfile for SIS3300 and SIS3301                           */
/*                                                                         */
/*  Autor:                TH                                               */
/*  date:                 10.05.2002                                       */
/*  last modification:    06.06.2002                                       */
/*                                                                         */
/* ----------------------------------------------------------------------- */
/*                                                                         */
/*  SIS  Struck Innovative Systeme GmbH                                    */
/*                                                                         */
/*  Harksheider Str. 102A                                                  */
/*  22399 Hamburg                                                          */
/*                                                                         */
/*  Tel. +49 (0)40 60 87 305 0                                             */
/*  Fax  +49 (0)40 60 87 305 20                                            */
/*                                                                         */
/*  http://www.struck.de                                                   */
/*                                                                         */
/*   2002                                                                 */
/*                                                                         */
/***************************************************************************/





/* SIS3300 12-bit,100MHz */
/* addresses  */

/* general registers */
#define SIS3300_CONTROL_STATUS                       0x0	  /* read/write; D32 */
#define SIS3300_MODID                                0x4	  /* read only; D32 */
#define SIS3300_IRQ_CONFIG                           0x8      /* read/write; D32 */
#define SIS3300_IRQ_CONTROL                          0xC      /* read/write; D32 */

#define SIS3300_ACQUISTION_CONTROL                  0x10      /* read/write; D32 */
#define SIS3300_START_DELAY                         0x14      /* read/write; D32 */
#define SIS3300_STOP_DELAY                          0x18      /* read/write; D32 */
#define SIS3300_TIMESTAMP_PREDIVIDER                0x1C      /* read/write; D32 */

#define SIS3300_KEY_RESET                           0x20	  /* write only; D32 */
												    
#define SIS3300_KEY_START                           0x30	  /* write only; D32 */
#define SIS3300_KEY_STOP                            0x34	  /* write only; D32 */

#define SIS3300_KEY_START_AUTO_BANK_SWITCH          0x40	  /* write only; D32 */
#define SIS3300_KEY_STOP_AUTO_BANK_SWITCH           0x44	  /* write only; D32 */
#define SIS3300_KEY_BANK1_FULL_FLAG                 0x48	  /* write only; D32 */
#define SIS3300_KEY_BANK2_FULL_FLAG                 0x4C	  /* write only; D32 */


#define SIS3300_EVENT_TIMESTAMP_DIR_BANK1         0x1000  	  /* read only; D32, BLT32; size: 0x1000 */
#define SIS3300_EVENT_TIMESTAMP_DIR_BANK2         0x2000	  /* read only; D32, BLT32; size: 0x1000 */



/* registers specified for all ADC groups */
#define SIS3300_EVENT_CONFIG_ALL_ADC            0x100000      /* write only; D32 */
#define SIS3300_TRIGGER_THRESHOLD_ALL_ADC       0x100004      /* write only; D32 */
#define SIS3300_TRIGGER_FLAG_CLR_CNT_ALL_ADC    0x10001C      /* write only; D32 */
#define SIS3300_CLOCK_PREDIVIDER_ALL_ADC        0x100020      /* write only; D32 */
#define SIS3300_NO_OF_SAMPLE_ALL_ADC            0x100024      /* write only; D32 */
#define SIS3300_TRIGGER_SETUP_ALL_ADC           0x100028      /* write only; D32 */
#define SIS3300_MAX_NO_OF_EVENTS_ALL_ADC        0x10002C      /* write only; D32 */

#define SIS3300_EVENT_DIRECTORY_BANK1_ALL_ADC   0x101000	  /* read only; D32, BLT32 */
#define SIS3300_EVENT_DIRECTORY_BANK2_ALL_ADC   0x102000	  /* read only; D32, BLT32 */


/* registers specified for ADC group 1 (ADC1 and ADC2) */
#define SIS3300_EVENT_CONFIG_ADC12              0x200000      /* read/write; D32 */
#define SIS3300_TRIGGER_THRESHOLD_ADC12         0x200004      /* read/write; D32 */
#define SIS3300_BANK1_ADDR_CNT_ADC12            0x200008      /* read only; D32 */
#define SIS3300_BANK2_ADDR_CNT_ADC12            0x20000C      /* read only; D32 */

#define SIS3300_BANK1_EVENT_CNT_ADC12           0x200010      /* read only; D32 */
#define SIS3300_BANK2_EVENT_CNT_ADC12           0x200014      /* read only; D32 */
#define SIS3300_ACTUAL_SAMPLE_VALUE_ADC12       0x200018      /* read only; D32 */
#define SIS3300_TRIGGER_FLAG_CLR_CNT_ADC12      0x20001C      /* read/write; D32 */

#define SIS3300_CLOCK_PREDIVIDER_ADC12          0x200020      /* read/write; D32 */
#define SIS3300_NO_OF_SAMPLE_ADC12              0x200024      /* read/write; D32 */
#define SIS3300_TRIGGER_SETUP_ADC12             0x200028      /* read/write; D32 */
#define SIS3300_MAX_NO_OF_EVENTS_ADC12          0x20002C      /* read/write; D32 */

#define SIS3300_EVENT_DIRECTORY_BANK1_ADC12     0x201000	  /* read only; D32, BLT32; size: 0x1000 */
#define SIS3300_EVENT_DIRECTORY_BANK2_ADC12     0x202000	  /* read only; D32, BLT32; size: 0x1000 */


/* registers specified for ADC group 2 (ADC3 and ADC4) */
#define SIS3300_EVENT_CONFIG_ADC34              0x280000      /* read/write; D32 */
#define SIS3300_TRIGGER_THRESHOLD_ADC34         0x280004      /* read/write; D32 */
#define SIS3300_BANK1_ADDR_CNT_ADC34            0x280008      /* read only; D32 */
#define SIS3300_BANK2_ADDR_CNT_ADC34            0x28000C      /* read only; D32 */

#define SIS3300_BANK1_EVENT_CNT_ADC34           0x280010      /* read only; D32 */
#define SIS3300_BANK2_EVENT_CNT_ADC34           0x280014      /* read only; D32 */
#define SIS3300_ACTUAL_SAMPLE_VALUE_ADC34       0x280018      /* read only; D32 */
#define SIS3300_TRIGGER_FLAG_CLR_CNT_ADC34      0x28001C      /* read/write; D32 */

#define SIS3300_CLOCK_PREDIVIDER_ADC34          0x280020      /* read/write; D32 */
#define SIS3300_NO_OF_SAMPLE_ADC34              0x280024      /* read/write; D32 */
#define SIS3300_TRIGGER_SETUP_ADC34             0x280028      /* read/write; D32 */
#define SIS3300_MAX_NO_OF_EVENTS_ADC34          0x28002C      /* read/write; D32 */

#define SIS3300_EVENT_DIRECTORY_BANK1_ADC34     0x281000	  /* read only; D32, BLT32; size: 0x1000 */
#define SIS3300_EVENT_DIRECTORY_BANK2_ADC34     0x282000	  /* read only; D32, BLT32; size: 0x1000 */


/* registers specified for ADC group 3 (ADC5 and ADC6) */
#define SIS3300_EVENT_CONFIG_ADC56              0x300000      /* read/write; D32 */
#define SIS3300_TRIGGER_THRESHOLD_ADC56         0x300004      /* read/write; D32 */
#define SIS3300_BANK1_ADDR_CNT_ADC56            0x300008      /* read only; D32 */
#define SIS3300_BANK2_ADDR_CNT_ADC56            0x30000C      /* read only; D32 */

#define SIS3300_BANK1_EVENT_CNT_ADC56           0x300010      /* read only; D32 */
#define SIS3300_BANK2_EVENT_CNT_ADC56           0x300014      /* read only; D32 */
#define SIS3300_ACTUAL_SAMPLE_VALUE_ADC56       0x300018      /* read only; D32 */
#define SIS3300_TRIGGER_FLAG_CLR_CNT_ADC56      0x30001C      /* read/write; D32 */

#define SIS3300_CLOCK_PREDIVIDER_ADC56          0x300020      /* read/write; D32 */
#define SIS3300_NO_OF_SAMPLE_ADC56              0x300024      /* read/write; D32 */
#define SIS3300_TRIGGER_SETUP_ADC56             0x300028      /* read/write; D32 */
#define SIS3300_MAX_NO_OF_EVENTS_ADC56          0x30002C      /* read/write; D32 */

#define SIS3300_EVENT_DIRECTORY_BANK1_ADC56     0x301000	  /* read only; D32, BLT32; size: 0x1000 */
#define SIS3300_EVENT_DIRECTORY_BANK2_ADC56     0x302000	  /* read only; D32, BLT32; size: 0x1000 */


/* registers specified for ADC group 4 (ADC7 and ADC7) */
#define SIS3300_EVENT_CONFIG_ADC78              0x380000      /* read/write; D32 */
#define SIS3300_TRIGGER_THRESHOLD_ADC78         0x380004      /* read/write; D32 */
#define SIS3300_BANK1_ADDR_CNT_ADC78            0x380008      /* read only; D32 */
#define SIS3300_BANK2_ADDR_CNT_ADC78            0x38000C      /* read only; D32 */

#define SIS3300_BANK1_EVENT_CNT_ADC78           0x380010      /* read only; D32 */
#define SIS3300_BANK2_EVENT_CNT_ADC78           0x380014      /* read only; D32 */
#define SIS3300_ACTUAL_SAMPLE_VALUE_ADC78       0x380018      /* read only; D32 */
#define SIS3300_TRIGGER_FLAG_CLR_CNT_ADC78      0x38001C      /* read/write; D32 */

#define SIS3300_CLOCK_PREDIVIDER_ADC78          0x380020      /* read/write; D32 */
#define SIS3300_NO_OF_SAMPLE_ADC78              0x380024      /* read/write; D32 */
#define SIS3300_TRIGGER_SETUP_ADC78             0x380028      /* read/write; D32 */
#define SIS3300_MAX_NO_OF_EVENTS_ADC78          0x38002C      /* read/write; D32 */

#define SIS3300_EVENT_DIRECTORY_BANK1_ADC78     0x381000	  /* read only; D32, BLT32; size: 0x1000 */
#define SIS3300_EVENT_DIRECTORY_BANK2_ADC78     0x382000	  /* read only; D32, BLT32; size: 0x1000 */






/* memory specified for Bank1  */
/* write D32; read D32, BLT32, MBL64, 2eVME; size: 0x80000 bytes (0x20000 Lwords) */
#define SIS3300_MEMBASE_BANK1_ADC12             0x400000
#define SIS3300_MEMBASE_BANK1_ADC34             0x480000
#define SIS3300_MEMBASE_BANK1_ADC56             0x500000
#define SIS3300_MEMBASE_BANK1_ADC78             0x580000


/* memory specified for Bank2  */
/* write D32; read D32, BLT32, MBL64, 2eVME; size: 0x80000 bytes (0x20000 Lwords) */
#define SIS3300_MEMBASE_BANK2_ADC12             0x600000
#define SIS3300_MEMBASE_BANK2_ADC34             0x680000
#define SIS3300_MEMBASE_BANK2_ADC56             0x700000
#define SIS3300_MEMBASE_BANK2_ADC78             0x780000







/* register default values after power up or KEY_RESET */
#define SIS3300_DEFAULT_STATUS                       0x0
#define SIS3300_DEFAULT_IRQ_CONFIG                   0x0
#define SIS3300_DEFAULT_IRQ_CONTROL                  0x0

#define SIS3300_DEFAULT_ACQ_CONTROL                  0x0
#define SIS3300_DEFAULT_START_DELAY                  0x0
#define SIS3300_DEFAULT_STOP_DELAY                   0x0
#define SIS3300_DEFAULT_TIMEST_PREDI                 0x0


#define SIS3300_DEFAULT_EVENT_CONFIG_ADC12        0x1000
#define SIS3300_DEFAULT_EVENT_CONFIG_ADC34        0x1100
#define SIS3300_DEFAULT_EVENT_CONFIG_ADC56        0x1200
#define SIS3300_DEFAULT_EVENT_CONFIG_ADC78        0x1300

#define SIS3300_DEFAULT_TRIG_THRESHOLD        0x0FFF0FFF
#define SIS3301_DEFAULT_TRIG_THRESHOLD        0x3FFF3FFF

#define SIS3300_DEFAULT_TRIG_FLAG_CLR_CNT            0x0
#define SIS3300_DEFAULT_CLOCK_PREDIVIDER             0x0

#define SIS3300_DEFAULT_NO_OF_SAMPLE                 0x0
#define SIS3300_DEFAULT_TRIGGER_SETUP                0x0
#define SIS3300_DEFAULT_MAX_NO_OF_EVENTS             0x0




/* bits */


/* maskbits of Bankx memory */
#define SIS3300_ADC_MASK                            0x0FFF0FFF
#define SIS3301_ADC_MASK                            0x3FFF3FFF

#define SIS3300_GATE_CHAINING_START_BIT             0x00008000



/* bits of SIS3300_CONTROL register ; J-K register*/

/* disable bits ; default after Reset */
#define CTRL_DISABLE_BANK_FULL_PULSE_ON_OUTPUT3      0x3000000      /* default after Reset */
#define CTRL_DISABLE_BANK_FULL_PULSE_ON_OUTPUT2      0x2000000      /* default after Reset */
#define CTRL_DISABLE_BANK_FULL_PULSE_ON_OUTPUT1      0x1000000      /* default after Reset */

#define CTRL_DISABLE_INTERNAL_TRIGGER_STOP           0x400000      /* default after Reset */
#define CTRL_DISABLE_TRIGGER_OUT_UPON_STARTED        0x200000      /* default after Reset */
#define CTRL_DISABLE_TRIGGER_OUT_INVERT              0x100000      /* default after Reset */

#define CTRL_USE_USER_OUTPUT_ON_OUTPUT1               0x40000      /* default after Reset */
#define CTRL_CLR_USER_OUTPUT                          0x20000	   /* default after Reset */
#define CTRL_USER_LED_OFF                             0x10000	   /* default after Reset */


/* enable bits */

#define CTRL_ENABLE_BANK_FULL_PULSE_ON_OUTPUT3          0x300
#define CTRL_ENABLE_BANK_FULL_PULSE_ON_OUTPUT2          0x200
#define CTRL_ENABLE_BANK_FULL_PULSE_ON_OUTPUT1          0x100      /* higher priority as CTRL_USE_TRIGGER_OUTPUT_ON_OUTPUT1 */

#define CTRL_ENABLE_INTERNAL_TRIGGER_STOP                0x40
#define CTRL_ENABLE_TRIGGER_OUT_UPON_STARTED             0x20
#define CTRL_ENABLE_TRIGGER_OUT_INVERT                   0x10

#define CTRL_USE_TRIGGER_OUTPUT_ON_OUTPUT1                0x4
#define CTRL_SET_USER_OUTPUT                              0x2
#define CTRL_USER_LED_ON                                  0x1



/* bits of SIS3300_AQC register ; J-K register*/

/* disable bits ; default after Reset */
#define ACQ_DISABLE_MULTIPLEXER_MODE            0x80000000  /* default after Reset  */

#define ACQ_DISABLE_RANDOM_CLOCK_MODE            0x8000000  /* default after Reset  */
#define ACQ_DISABLE_GATE_MODE                    0x4000000  /* default after Reset  */
#define ACQ_DISABLE_P2_START_STOP                0x2000000  /* default after Reset  */
#define ACQ_DISABLE_LEMO_START_STOP              0x1000000  /* default after Reset  */

#define ACQ_DISABLE_STOP_DELAY                    0x800000  /* default after Reset  */
#define ACQ_DISABLE_START_DELAY                   0x400000  /* default after Reset  */
#define ACQ_DISABLE_MULTI_EVENT_MODE              0x200000  /* default after Reset  */
#define ACQ_DISABLE_AUTOSTART                     0x100000  /* default after Reset  */

#define ACQ_DISABLE_BANK_SWITCH_MODE               0x40000  /* default after Reset  */
#define ACQ_DISABLE_CLOCK_TO_BANK2                 0x20000  /* default after Reset  */
#define ACQ_DISABLE_CLOCK_TO_BANK1                 0x10000  /* default after Reset  */


/* enable bits */
#define ACQ_ENABLE_MULTIPLEXER_MODE                 0x8000

#define ACQ_ENABLE_RANDOM_CLOCK_MODE                 0x800
#define ACQ_ENABLE_GATE_MODE                         0x400
#define ACQ_ENABLE_P2_START_STOP                     0x200
#define ACQ_ENABLE_LEMO_START_STOP                   0x100

#define ACQ_ENABLE_STOP_DELAY                         0x80
#define ACQ_ENABLE_START_DELAY                        0x40
#define ACQ_ENABLE_MULTI_EVENT_MODE                   0x20
#define ACQ_ENABLE_AUTOSTART                          0x10

#define ACQ_ENABLE_BANK_SWITCH_MODE                    0x4
#define ACQ_ENABLE_CLOCK_TO_BANK2                      0x2  /* arm Bank2 */
#define ACQ_ENABLE_CLOCK_TO_BANK1                      0x1  /* arm Bank1 */


/* define sample clock */
#define ACQ_SET_CLOCK_TO_100MHZ                 0x70000000  /* default after Reset  */
#define ACQ_SET_CLOCK_TO_50MHZ                  0x60001000
#define ACQ_SET_CLOCK_TO_25MHZ                  0x50002000
#define ACQ_SET_CLOCK_TO_12_5MHZ                0x40003000
#define ACQ_SET_CLOCK_TO_6_25MHZ                0x30004000
#define ACQ_SET_CLOCK_TO_3_125MHZ               0x20005000
#define ACQ_SET_CLOCK_TO_LEMO_CLOCK_IN          0x10006000
#define ACQ_SET_CLOCK_TO_P2_CLOCK_IN            0x00007000


/* Status bits */
#define ACQ_STATUS_SWITCH_MODE_BANK2_FULL         0x800000
#define ACQ_STATUS_SWITCH_MODE_BANK2_BUSY         0x400000
#define ACQ_STATUS_SWITCH_MODE_BANK1_FULL         0x200000
#define ACQ_STATUS_SWITCH_MODE_BANK1_BUSY         0x100000

#define ACQ_STATUS_BANK_SWITCH_BUSY                0x40000

#define ACQ_STATUS_ADC_BUSY                        0x10000

#define ACQ_STATUS_CLOCK_TO_BANK2                      0x2
#define ACQ_STATUS_CLOCK_TO_BANK1                      0x1




/* bits of SIS3300_Configuration register ; D-register*/

#define CONF_ENABLE_GATE_CHAINING_MODE               0x10


#define CONF_PAGE_SIZE_128K_AUTOSTOP                  0x0
#define CONF_PAGE_SIZE_16K_AUTOSTOP                   0x1
#define CONF_PAGE_SIZE_4K_AUTOSTOP                    0x2
#define CONF_PAGE_SIZE_2K_AUTOSTOP                    0x3
#define CONF_PAGE_SIZE_1K_AUTOSTOP                    0x4
#define CONF_PAGE_SIZE_512_AUTOSTOP                   0x5
#define CONF_PAGE_SIZE_256_AUTOSTOP                   0x6
#define CONF_PAGE_SIZE_128_AUTOSTOP                   0x7

#define CONF_PAGE_SIZE_128K_WRAP                      0x8
#define CONF_PAGE_SIZE_16K_WRAP                       0x9
#define CONF_PAGE_SIZE_4K_WRAP                        0xA
#define CONF_PAGE_SIZE_2K_WRAP                        0xB
#define CONF_PAGE_SIZE_1K_WRAP                        0xC
#define CONF_PAGE_SIZE_512_WRAP                       0xD
#define CONF_PAGE_SIZE_256_WRAP                       0xE
#define CONF_PAGE_SIZE_128_WRAP                       0xF



/* bits of Trigger Setuo register  */

#define TRIG_SETUP_ENABLE_PULS                 0x10000000
#define TRIG_SETUP_PULS_1_CLK                     0x10000
#define TRIG_SETUP_PULS_2_CLK                     0x20000
#define TRIG_SETUP_PULS_3_CLK                     0x30000
#define TRIG_SETUP_PULS_4_CLK                     0x40000
#define TRIG_SETUP_PULS_5_CLK                     0x50000
#define TRIG_SETUP_PULS_6_CLK                     0x60000
#define TRIG_SETUP_PULS_7_CLK                     0x70000
#define TRIG_SETUP_PULS_8_CLK                     0x80000
#define TRIG_SETUP_PULS_9_CLK                     0x90000
#define TRIG_SETUP_PULS_10_CLK                    0xA0000
#define TRIG_SETUP_PULS_11_CLK                    0xB0000
#define TRIG_SETUP_PULS_12_CLK                    0xC0000
#define TRIG_SETUP_PULS_13_CLK                    0xD0000
#define TRIG_SETUP_PULS_14_CLK                    0xE0000
#define TRIG_SETUP_PULS_15_CLK                    0xF0000

#define TRIG_SETUP_ENABLE_NM_MODE               0x1000000

#define TRIG_SETUP_N_OVER_1_CLK                     0x100
#define TRIG_SETUP_N_OVER_2_CLK                     0x200
#define TRIG_SETUP_N_OVER_3_CLK                     0x300

#define TRIG_SETUP_N_OVER_13_CLK                    0xC00
#define TRIG_SETUP_N_OVER_14_CLK                    0xE00
#define TRIG_SETUP_N_OVER_15_CLK                    0xF00


#define TRIG_SETUP_M_UNDER_1_CLK                      0x1
#define TRIG_SETUP_M_UNDER_2_CLK                      0x2
#define TRIG_SETUP_M_UNDER_3_CLK                      0x3

#define TRIG_SETUP_M_UNDER_15_CLK                     0xF




#define ARMEDSTARTED                   0x20
#define STOP_DELAY_ENABLE              0x80
#define FP_LEMO                       0x100

#define CLOCK_TO_BANK1                 0x01
#define CLOCK_TO_BANK2                 0x02

#define WRAP                            0x8
#define EXTCLOCK                        0x6

#define MEMSIZE                     0x20000



