/* $ZEL: vertex_rem_init.c,v 1.2 2004/05/27 23:10:49 wuestner Exp $ */

/*
 * Copyright (c) 2004
 * 	Peter Wuestner.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "sis1100_sc.h"

int
vertex_rem_init(struct sis1100_softc* sc)
{
#define MIN_FV 0
#define MAX_FV 0
    u_int32_t hv, fk, fv, stat;

    hv=(sc->remote_ident>>8)&0xff;
    fk=(sc->remote_ident>>16)&0xff;
    fv=(sc->remote_ident>>24)&0xff;

    switch (sc->remote_ident&0x00ffff00) {
    case 0x00010100:
        if (fv<MIN_FV) {
            pERROR(sc, "vertex: remote firmware version too old;"
                    " at least version %d is required.",
                    MIN_FV);
            return -1;
        }
        if (fv>MAX_FV) {
            pINFO(sc, "vertex: Driver not tested with"
                    " remote firmware versions greater than %d.",
                    MAX_FV);
        }
        break;
    default:
        pERROR(sc, "vertex: remote hw/fw type not supported");
        return -1;
    }

    sc->ram_size=0;
    sc->dsp_present=0;

    SEM_LOCK(sc->sem_hw);
    /*vertex_writeremreg(sc, vme_irq_sc, 0x00fe0001, 1);*/ /* disable IRQs */
    vertex_readremreg(sc, sc, &stat, 1);
    SEM_UNLOCK(sc->sem_hw);
    pINFO(sc, "vertex: remote stat=0x%08x", stat);

    return 0;
}
