/*
 * $ZEL$
 */

#include "test_3100.h"


#define ADDR 0
#define MAX 100
#define LOOPS 10000

int
check_VME_BLOCK_READ(struct path* path, u_int32_t start, u_int32_t size)
{
    struct sis1100_vme_block_req req;
    int res, i;

    if (path->type!=sis1100_subdev_remote) return 0;
    if (!path->ident.remote_online) {
        printf("remote Interface is offline.\n");
        return 0;
    }
    if (path->ident.remote.hw_type!=sis1100_hw_vme) {
        printf("remote Interface is not VME.\n");
        return 0;
    }

    req.size=4;
    req.fifo=1;
    req.am=0xb;
    req.addr=ADDR;
    req.data=(u_int8_t*)buf;

    for (i=0; i<=LOOPS; i++) {
        req.num=MAX;
        req.error=0;
        res=ioctl(path->p, SIS3100_VME_BLOCK_READ, &req);
        if (res<0) {
            printf("VME_BLOCK_READ: errno=%s\n", strerror(errno));
            break;
        } else {
            if (req.error!=0x211) {
                printf("VME_BLOCK_READ: num=%d, error=0x%x\n", req.num, req.error);
                break;
            }
        }
    }
    if (i<LOOPS) {
        printf("VME_BLOCK_READ: aborted after %d loops\n", i);
    }

    return 0;
}
