/*
 * $ZEL$
 */

#include "test_3100.h"

int
check_w_block(struct path* path, u_int32_t start, u_int32_t max)
{
    int i, res, first, count;
    u_int32_t x=0xa5a55a5a;

    printf("check_w_block: max=0x%08x buf=%p\n", max, buf);
    for (i=0; i<max; i++) {
        buf[i]=i;
    }
/*
    if (lseek(path->p, start, SEEK_SET)!=start) {
        printf("\nlseek(%s, 0x%08x, SEEK_SET): %s\n",
                path->name, start, strerror(errno));
        return -1;
    }

    for (i=0; i<max; i++) {
        res=write(path->p, &x, 4);
        if (res!=4) {
            printf("\nwrite(%s, start+%d): %s\n", path->name, i, strerror(errno));
            return -1;
        }
    }
*/
    if (lseek(path->p, start, SEEK_SET)!=start) {
        printf("\nlseek(%s, 0x%08x, SEEK_SET): %s\n",
                path->name, start, strerror(errno));
        return -1;
    }

    res=write(path->p, buf, 4*max);
    if (res!=4*max) {
        printf("\nwrite(%s, ..., 4*%d): %s\n", path->name, max, strerror(errno));
        return -1;
    }
return -1;

    for (i=0; i<max; i++) {
        buf[i]=~i;
    }
    if (lseek(path->p, start, SEEK_SET)!=start) {
        printf("\nlseek(%s, 0x%08x, SEEK_SET): %s\n",
                path->name, start, strerror(errno));
        return -1;
    }
    for (i=0; i<max; i++) {
        res=read(path->p, buf+i, 4);
        if (res!=4) {
            printf("\nread(%s, start+%d): %s", path->name, i, strerror(errno));
            return -1;
        }
    }
    first=1; count=0;
    for (i=0; i<max; i++) {
        if (buf[i]!=i) {
            if (first) {
                printf("\n%s: check_w_block (max=%d):\n",
                        path->name, max);
                first=0;
            }
            if (count<10) printf("[%3d/%p]: %08x --> %08x\n", i, buf+i, i, buf[i]);
            count++;
        }
    }
    if (count) return -1;
    return 0;
}
