#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/ioctl.h>

#include "../../V1.0/linux-gnu/dev/pci/sis1100_var.h"
#include "../../V1.0/linux-gnu/sis3100_calls/sis3100_vme_calls.h"


/*
#define swap_int(x) ((((x)>>24)&0x000000ff) |\
                     (((x)>> 8)&0x0000ff00) |\
                     (((x)<< 8)&0x00ff0000) |\
                     (((x)<<24)&0xff000000))

*/

#define SHARCRAM  0x81200000
#define D48REG    0x81300000





#define swap_int(x)  ((((x)>>24)&0x000000ff) |\
                      (((x)>> 8)&0x0000ff00) |\
                      (((x)<< 8)&0x00ff0000) |\
                      (((x)<<24)&0xff000000))









/****************************************************************************/

/****************************************************************************/
int main(int argc, char* argv[])
{

int p;
int p_sharc;
int offset ;
u_int32_t data ;
u_int32_t addr ;

int return_code ;

FILE *loaderfile;

unsigned int tempword[0x10000];
int retcode=1;

int count=0 ;
int loadcount=0; 
int currentaddress ;

/*
int i;
char *dummy;
*/

if (argc<4)
  {
  fprintf(stderr, "usage: %s path (sis1100)  path2 (sis3100sharc) Sharc.ldr  \n", argv[0]);
  return 1;
  }

if ((p=open(argv[1], O_RDWR, 0))<0) {
	perror("open");
	return 1;
}

if ((p_sharc=open(argv[2], O_RDWR, 0))<0) {
	perror("open");
	return 1;
}


  printf("LED an \n");
  offset = 0x00000100;
  return_code = s3100_control_write(p, offset, 0x00000080) ; 
  if (return_code != 0) printf("s3100_control_write:   return_code = 0x%08x\n", return_code );         



/* open SHARC loader file */
/* loaderfile=fopen("led_test.ldr","r"); */

/* open SHARC loader file */
  loaderfile=fopen(argv[3],"r");


 if (loaderfile>0) {
     printf("loader file opened\n");
     while (retcode>0) {
	 retcode=fscanf(loaderfile,"0x%4x\n",&tempword[count]);
         if (count<0x10000) {
            count++;
	 }
         else {
	     printf("load file size too big\n");
             return -1;
	 }
     }
     printf("load file length: %d\n",count);
    
 }
 fclose(loaderfile);
 




  offset = 0x00000100;
  return_code = s3100_control_write(p, offset, 0x00000080) ; 
  if (return_code != 0) printf("s3100_control_write:   return_code = 0x%08x\n", return_code );         


/* load SHARC */


/* 1. Reset SHARC */
  printf("resetting SHARC DSP\n");
  offset =  0x00000300 ;
  return_code = s3100_control_write(p, offset, 0x00000800)	 ; /* set DSP Control Enable Bit*/
  if (return_code != 0) printf("s3100_control_write:   return_code = 0x%08x\n", return_code );         


  offset =  0x00000300 ;
  return_code = s3100_control_write(p, offset, 0x01000000)	 ;
  if (return_code != 0) printf("s3100_control_write:   return_code = 0x%08x\n", return_code );         
  return_code = s3100_control_read(p, offset, &data)			 ;
  if (return_code != 0) printf("s3100_control_read:   return_code = 0x%08x\n", return_code );         
  printf("Read at Offset = 0x%08x  Data = 0x%08x\n", offset, data);  




  printf("loading SHARC DSP\n");
  currentaddress=SHARCRAM;
  while (loadcount<count) {  
      addr = D48REG;
      data = tempword[loadcount];

      return_code = s3100_sharc_write(p_sharc, addr, &data, 0x1) ;
      if (return_code != 4) printf("s3100_sharc_write:   return_code = 0x%08x\n", return_code );         
      loadcount++;

      addr = currentaddress;
      data = ((tempword[loadcount+1] << 16 ) & 0xFFFF0000) + (tempword[loadcount] & 0x0000FFFF);

      return_code = s3100_sharc_write(p_sharc, addr, &data, 0x1) ;
      if (return_code != 4) printf("s3100_sharc_write:   return_code = 0x%08x\n", return_code );         
      currentaddress+=4;
      loadcount+=2;
  }







  printf("SHARC DSP loaded\n");
 
/* 3. Run SHARC */

  printf("starting SHARC DSP\n");

  offset =  0x00000300 ;
  return_code = s3100_control_write(p, offset, 0x0100)	 ;
  if (return_code != 0) printf("s3100_control_write:   return_code = 0x%08x\n", return_code );         

  return_code = s3100_control_read(p, offset, &data)			 ;
  if (return_code != 0) printf("s3100_control_read:   return_code = 0x%08x\n", return_code );         
  printf("Read at Addr = 0x%08x  Data = 0x%08x\n", addr, data);  

  

/* end load SHARC */


  printf("LED aus \n");
  offset = 0x00000100;
  return_code = s3100_control_write(p, offset, 0x00800000) ; 
  if (return_code != 0) printf("s3100_control_write:   return_code = 0x%08x\n", return_code );         

close(p);
close(p_sharc);




/*
do
{
  printf("\n");
  printf("\n");
  printf("\n");
  printf("\n");
  req.addr=0x00000000;


  for (i=0;i<0x8;i++)
  {
     if (ioctl(p, SIS1100_3100_6_READ, &req)<0) {printerror(&req, errno, 1); return 1;} 
     if (i==2)   printf("\n");
     printf("Read at Addr = 0x%08x  Data = 0x%08x\n", req.addr, req.data);
     req.addr= req.addr + 0x4 ;
   }

  printf("\n");



   req.addr=0x00000040;
  for (i=0;i<0x11;i++)
  {
      if (ioctl(p, SIS1100_3100_6_READ, &req)<0) {printerror(&req, errno, 1); return 1;}  
     printf("Read at Addr = 0x%08x  Data = 0x%08x\n", req.addr, req.data);
     req.addr= req.addr + 0x4 ;
   }

  sleep(1);
} while (0);
*/

close(p);
close(p_sharc);


return 0;
}





























