#define _GNU_SOURCE
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/ioctl.h>


#include "dev/pci/sis1100_var.h"
#include "sis3100_vme_calls.h"


/****************************************************************************/
int main(int argc, char* argv[])
{

int p;
int mod_base;
u_int32_t data ;
int return_code ;
int loop_counter ;

    struct sis1100_ctrl_reg reg;



if (argc<2)
  {
  fprintf(stderr, "usage: %s  VME_BASE_ADDR   LOOP_COUNTER \n", argv[0]);
  return 1;
  }



/* open VME */
   if ((p=open("/tmp/sis1100", O_RDWR, 0))<0) {
     printf("error on opening VME environment (/tmp/sis1100)\n");
     return -1;
   }

mod_base     = strtoul(argv[1],NULL,0) ;

loop_counter  = 1 ;
if (argc>2) loop_counter  = strtoul(argv[2],NULL,0) ;

#ifdef raus
    reg.offset=0x100;
    reg.val=0x1000000;
    if (ioctl(p, SIS3100_CONTROL_WRITE, &reg)<0) {
              perror("SIS3100_CONTROL_WRITE");
              return -1;
          }
#endif

do {
  return_code =  vme_A32D32_read(p, mod_base, &data ) ;
  loop_counter = loop_counter - 1 ;
 } while (loop_counter != 0 ) ;

printf("vme_A32D32_read:   return_code = 0x%08x\n", return_code );
printf("vme_A32D32_read:   data = 0x%08x\n", data );


close(p);
return 0;
}





 




























