/***************************************************************************/
/*                                                                         */
/*   Name:  vmram_t1.asm                                                   */
/*                                                                         */
/*   Zweck: VME Ram test 1                                                 */
/*          - write increment pattern to FPGA internal RAM (256 LWords)    */
/*                                                                         */
/*   Autor: TH                                                             */
/*   Datum: 12.01.2002                                                     */
/*                                                                         */
/*                                                                         */
/* ----------------------------------------------------------------------- */
/*                                                                         */
/*                                                                         */
/*  Copyright (c) 2002 SIS GmbH 22399 Hamburg.  All rights reserved.       */
/*                                                                         */
/*                                                                         */
/***************************************************************************/



#include "..\header\s3100def.h"


#define DPM_PARAMETER_CMD		FPGA_DUALPORT_RAM  			 /* use for ACK ; 0x40000000 for BUSY; 0x8eee eeee for Error */
#define DPM_PARAMETER1			FPGA_DUALPORT_RAM + 0x1 	 /* use as SDRAM address pointer                             */
#define DPM_PARAMETER2			FPGA_DUALPORT_RAM + 0x2 	 /* use as VME address pointer                               */
#define DPM_PARAMETER3			FPGA_DUALPORT_RAM + 0x3 	 /* use as length (number of lwords)                         */
#define DPM_PARAMETER4			FPGA_DUALPORT_RAM + 0x4 	 /* use as max. number of loops                              */
#define DPM_PARAMETER5			FPGA_DUALPORT_RAM + 0x5 	 /* use as loop_counter                                      */

#define DPM_PARAMETER6			FPGA_DUALPORT_RAM + 0x6 	 /* use in case of error for VME Status                      */
#define DPM_PARAMETER7			FPGA_DUALPORT_RAM + 0x7 	 /* use in case of error for written word information        */
#define DPM_PARAMETER8			FPGA_DUALPORT_RAM + 0x8 	 /* use in case of error for read word information           */
#define DPM_PARAMETER9			FPGA_DUALPORT_RAM + 0x9 	 /* use in case of error for address information             */



#define VME_CMD_WRITE 			0x1000 		   /* read from SDRAM and write it to VME */
#define VME_CMD_READ_D32		0x1100 		   /* read (D32) from VME and write it to SDRAM */
#define VME_CMD_READ_BLT32		0x1101 		   /* read (BLT32) from VME and write it to SDRAM */
#define VME_CMD_WR_RD_TEST		0x1200 

								
#define VME_CMD_READY			0x20000000
#define VME_CMD_BUSY			0x40000000
#define VME_CMD_FINISHED		0x80000000 
#define VME_CMD_WRONG_PARAMETER	0x8eee0001
#define VME_CMD_ERROR			0x8eeeeeee



.SEGMENT/PM     seg_prog;
				
Start:
		BIT SET ASTAT 0x780000 ; /* set  Flag 3 .. FLAG 0           */
		BIT SET MODE2 0x78000;   /* Flag 3 .. Flag 0 sind outputs   */ 


// clear internal FPGA Dual Ported Ram
		R1 = 0x0 ;
		I1 = FPGA_DUALPORT_RAM ;
		M1 = 0x1 ;
        LCNTR=0x100, DO(PC,1) UNTIL LCE ;
		DM(I1,M1) = R1 ;


		R1 = VME_CMD_READY ;
		DM(DPM_PARAMETER_CMD) = R1 ;



	    
	    
	    
// Main Command Loop 

Command_Loop:
		R1 =  DM (DPM_PARAMETER_CMD) ;    /* read Command */

		R2 =  VME_CMD_WRITE ;
		COMP (R1,R2) ;
		IF EQ JUMP (PC,Vme_Cmd_Write_Start) ;



	    JUMP (PC,Command_Loop)       ;
				


				


Wrong_Paramter_End:
		R2 = VME_CMD_WRONG_PARAMETER ;
		DM (DPM_PARAMETER_CMD) = R2  ;
	    JUMP (PC,Command_Loop)       ;
	    
	    
	    

Vme_Cmd_Write_Start:	    
		R1 = VME_CMD_BUSY  ;
		R2 = R2 or R1 ;
		DM (DPM_PARAMETER_CMD) = R2  ;

	// check Parameter1: 1 <= Loop counter if <1 or > 0x1000 */ 
		R6 = 0x4 ;
		M3 = 1 ;
		R3 = DM(DPM_PARAMETER1) ;  /* SDRAM offset Address */
		R4 = DM(DPM_PARAMETER2) ;  /* VME Address */
		R5 = DM(DPM_PARAMETER3) ;  /* Length; number of LWORDS  */

	    R7 = SDRAM_SGL_BASE ;    /* SDRAM Address Base Address */
	    R3 = R3 + R7 ;           /* SDRAM Address */

        LCNTR=R5, DO(PC,5) UNTIL LCE ;
        R0 = DM(I3,M1) ;	         	/* read SDRAM */
		DM(VME_WRITE_DATA_REG) = R0 ;
 	   	DM (VME_SINGLE_CYCLE  + VME_WRITE + VME_AM_9) = R4 ;
        CALL Wait_On_VME_Busy ;   /* R15 will be used */
 	   	R4 = R4 + R6 ;



		R2 = VME_CMD_FINISHED ;
		DM (DPM_PARAMETER_CMD) = R2  ;

	    JUMP (PC,Command_Loop)       ;






/* subroutine */

Wait_On_VME_Busy:
 	   	R15 = DM (LOC_SEQ_STATUS)  ;     	 
		BTST R15 by 0	;	
 		IF NOT SZ JUMP (PC,Wait_On_VME_Busy) ;  
		RTS ;




		
.ENDSEG;


