/*
 * $ZEL$
 */

#include "test_3100.h"

u_int32_t* buf;
int bufsize;

struct path* pathes;
int numpathes;

static void
printusage(int argc, char* argv[])
{
    printf("usage: %s [-h] pathnames...\n",
        argv[0]);
}

static void
printhelp(int argc, char* argv[])
{
printf("printhelp not yet implemented\n");
}

static int
getoptions(int argc, char* argv[])
{
    extern char *optarg;
    extern int optind;
    extern int opterr;
    extern int optopt;
    int errflag, c, i;
    const char* args="h";

    optarg=0; errflag=0;
    
    while (!errflag && ((c=getopt(argc, argv, args))!=-1)) {
        switch (c) {
        case 'h': printhelp(argc, argv); break;
        default: errflag++;
        }
    }

    if (errflag || optind==argc) {
        printusage(argc, argv);
        return -1;
    }

    numpathes=argc-optind;
    pathes=malloc(numpathes*sizeof(struct path));
    for (i=0; i<numpathes; i++) {
        pathes[i].name=argv[optind+i];
        pathes[i].p=-1;
    }

    return 0;
}

typedef int(*testfunc)(struct path*);
struct testfunc {
    testfunc func;
    char* name;
};

struct testfunc funcs[]={
    init_path,                          "INIT",
    check_reopen,                       "REOPEN",
    /*check_RESET,*/
    check_MAPSIZE,                      "MAPSIZE",
    check_mmap,                         "MMAP", /* requires check_MAPSIZE */
    check_IDENT,                        "IDENT", /* can use check_mmap */

    /*check_rw,*/
    check_VME_BLOCK_READ,               "VME_BLOCK_READ",

#if 0
    check_SETVMESPACE,
    check_VME_PROBE,
    check_VME_READ,
    check_VME_WRITE,
    check_VME_BLOCK_WRITE,
    check_CONTROL_READ,
    check_CONTROL_WRITE,
    check_CONTROL_READ,
    check_CONTROL_WRITE,
    check_PIPE,
    check_LAST_ERROR,
    check_FIFOMODE,

    check_BIGENDIAN,

    check_IRQ_CTL,
    check_IRQ_GET,
    check_IRQ_ACK,
    check_IRQ_WAIT,

    check_MINDMALEN,

    check_FRONT_IO,
    check_FRONT_PULSE,
    check_FRONT_LATCH,

    check_VME_SUPER_BLOCK_READ,
    check_WRITE_PIPE,

    check_DMA_ALLOC,
    check_DMA_FREE,

    check_DUMP,
#endif
};
int numfuncs=sizeof(funcs)/sizeof(struct testfunc);

int main(int argc, char* argv[])
{
    int res=0, i, j;

    printf("\n==== SIS1100/3100 Test; V2.01 ====\n\n");

#if SIS1100_Version>0
    printf("%s is compiled for version %d.%d of sis1100 driver\n",
        argv[0],
        MAJORVERSION,
        MINORVERSION);
#else
    printf("the version %s is compiled for is not known; we assume %d.%d\n",
            argv[0],
        MAJORVERSION,
        MINORVERSION);
#endif

    if (getoptions(argc, argv)<0) return 1;

    bufsize=1024000;
    buf=calloc(bufsize, 4);
    if (!buf) {
        printf("\ncannot allocate %d words\n", bufsize);
        return -1;
    }

    srandom(17);

    for (i=0; i<numfuncs; i++) {
        printf("\nTesting %s:\n", funcs[i].name);
        for (j=0; j<numpathes; j++) {
            if (funcs[i].func(pathes+j)<0) {res=i+3; goto raus;}
        }
    }

raus:
    for (j=0; j<numpathes; j++) done_path(pathes+j);
    return res;
}
