/************************************************************************/
/*									*/
/*  This is the common header file for the CMEM_RCC 			*/
/*  driver, library & applications					*/
/*									*/
/*  12. Dec. 01  MAJO  created						*/
/*									*/
/*******C 2005 - The software with that certain something****************/

#ifndef _CMEM_RCC_COMMON_H
#define _CMEM_RCC_COMMON_H

#define CMEM_MAX_NAME    40
#define TYPE_GFP         1
#define TYPE_BPA         2

#ifdef __KERNEL__
  #include <linux/types.h>
  #define P_ID_CMEM_RCC 7   // Needs to be re-defined here since we do not want to include rcc_error.h at this level
#else
  #include "rcc_error/rcc_error.h"
  #include <sys/types.h>
#endif

// Error codes
enum
{
  CMEM_RCC_SUCCESS = 0,
  CMEM_RCC_ERROR_FAIL = (P_ID_CMEM_RCC << 8) + 1,
  CMEM_RCC_FILE,
  CMEM_RCC_NOTOPEN,
  CMEM_RCC_IOCTL,
  CMEM_RCC_MMAP,
  CMEM_RCC_MUNMAP,
  CMEM_RCC_OVERFLOW,
  CMEM_RCC_TOOBIG,
  CMEM_RCC_ILLHAND,
  CMEM_RCC_NOSIZE,
  CMEM_RCC_GETP,
  CMEM_RCC_CFU,
  CMEM_RCC_GFP,
  CMEM_RCC_BPA,
  CMEM_RCC_CTU,
  CMEM_RCC_KMALLOC,
  CMEM_RCC_NO_CODE
};

typedef struct
{
  u_long paddr;
  u_long uaddr;
  u_long kaddr;
  u_int size;
  u_int order;
  u_int locked;
  u_int type;
  u_int handle;
  char name[CMEM_MAX_NAME];
} cmem_rcc_t;

typedef u_int CMEM_Error_code_t;

#endif
