// $Id: vme_rcc_common.h,v 1.13 2007/11/08 07:56:44 joos Exp $
/************************************************************************/
/*									*/
/* File: vme_rcc_common.h						*/
/*									*/
/* This is the common public header file for RCC VMEbus library		*/
/* and driver								*/
/*									*/
/*  2. Nov. 01  MAJO  created						*/
/*  2. Nov. 01  JOP   interrupts					*/
/*  26 Nov. 01  JOP   bus errors					*/
/*  19 Apr. 02  JOP   ROAK / RORA					*/
/*  27 May. 02  JOP   modify interrupt API				*/
/*									*/
/************ C 2005 - The software with that certain something *********/

#ifndef _VME_RCC_COMMON_H 
#define _VME_RCC_COMMON_H

#ifdef __KERNEL__
  #include <linux/types.h>
  #define P_ID_VMERCC 2   // Needs to be re-defined here since we do not want to include rcc_error.h at this level
#else
  #include <sys/types.h>
#endif

/***************/
/*CCT SBC types*/
/***************/
#define VP_UNKNOWN 0
#define VP_PSE     1
#define VP_PMC     2
#define VP_100     3
#define VP_CP1     4
#define VP_110     5
#define VP_315     6
#define VP_317     7
#define VP_325     8

/*******************/
/* Other constants */
/*******************/
#define TEXT_SIZE1              3000
#define TEXT_SIZE2              20000
#define VME_MAXINTERRUPT        256	// Max # vectors per handle
#define VME_MAX_BERR_PROCS      10	// Max # processes with BERR handling
#define VME_MAX_MASTERMAP       200  // Max # of concurrent master mappings in all processes
#define VME_MAXCHAINEL          32       //Max number of elements in DMA chain 
#define VME_MAXCHAIN            16       //Max number of internal DMA chains
#define DMA_DESC_SIZE           (VME_MAXCHAINEL * VME_MAXCHAIN * sizeof(VME_DmaChain_t)) 

enum 
{
  VME_LEVELISDISABLED = 0,
  VME_INT_ROAK,
  VME_INT_RORA
};

/*************/
/*error codes*/
/*************/

//error codes
enum
{
  VME_SUCCESS = 0,
  VME_NOTKNOWN = (P_ID_VMERCC << 8) + 1,
  VME_UNKNOWN,
  VME_NOTOPEN,
  VME_RANGE,
  VME_BUSERROR,
  VME_ALIGN,
  VME_NOCHAINMEM,
  VME_NOBUSERROR,
  VME_TOOLONG,
  VME_DMABUSY,          // 10
  VME_TIMEOUT,
  VME_FILE,
  VME_NOMAP,
  VME_NOSTATMAP,
  VME_IRGBUSY,
  VME_EIO,
  VME_EFAULT,
  VME_VIRT,
  VME_REMAP,
  VME_ENOSYS,		// 20
  VME_NOSIZE,
  VME_CMEM_FAIL,
  VME_ERESTARTSYS,
  VME_DMAERR,
  VME_PCI_ERR,
  VME_VME_ERR,
  VME_PROTOCOL_ERR,
  VME_NOT_EXECUTED,     
  VME_MUNMAP,
  VME_ILLREV,		// 30
  VME_IOREMAP,
  VME_REQIRQ,
  VME_TOOMANYINT,
  VME_TOOMANYHDL,
  VME_INTUSED,
  VME_ILLINTLEVEL,
  VME_ILLINTTYPE,
  VME_INTCONF,
  VME_LVLDISABLED,
  VME_LVLISNOTRORA,	// 40
  VME_ILLINTHANDLE,
  VME_INTBYSIGNAL,
  VME_NOINTERRUPT,
  VME_ENOMEM,           
  VME_KMALLOC,
  VME_BERRTBLFULL,
  VME_BERRNOTFOUND,
  VME_ERROR_FAIL,
  VME_ILL_TO,
  VME_NODOMEMEM,	// 50
  VME_NO_CODE,
  VME_UNKNOWN_BOARD,
  VME_IO_FAIL,
  VME_SYSFAILTBLFULL,
  VME_SYSFAILTBLNOTLINKED,
  VME_SYSFAILNOTLINKED,
  VME_NOSTATMAP2,
  VME_IOUNMAP,
  VME_INTDISABLED,
  VME_NOCRCSRMAP
};


/*************/
/*ioctl codes*/
/*************/
enum 
{
  VMEMASTERMAP = 1,
  VMEMASTERUNMAP,
  VMEMASTERMAPDUMP,
  VMEBERRREGISTERSIGNAL,
  VMEBERRINFO,
  VMESLAVEMAP,
  VMESLAVEMAPDUMP,
  VMESCSAFE,
  VMEDMASTART,
  VMEDMAPOLL,               //10
  VMEDMADUMP,
  VMELINK,
  VMEINTENABLE,
  VMEINTDISABLE,
  VMEWAIT,
  VMEREGISTERSIGNAL,
  VMEINTERRUPTINFOGET,
  VMEUNLINK,
  VMETSTART,
  VMETSTOP,                 //20
  VMEUPDATE,
  VMESYSFAILUNLINK,
  VMESYSFAILWAIT,
  VMESYSFAILREGISTERSIGNAL,
  VMESYSFAILLINK,
  VMESYSFAILREENABLE,
  VMESYSFAILPOLL,
  VMESYSFAILSET,
  VMESYSFAILRESET,
  VMESYSRST,                //30
  VMETEST
};


/******************/
/*type definitions*/
/******************/
typedef struct 
{
  u_int vmebus_address;
  u_int window_size;
  u_int address_modifier;
  u_int options; 
} VME_MasterMap_t;

typedef struct 
{
  VME_MasterMap_t  in;
  u_int            pci_address;
  u_int            virt_address;  //for the user
  u_int            kvirt_address; //for the kernel
  u_int            used;
}VME_MasterMapInt_t;

typedef struct 
{
  u_int system_iobus_address;
  u_int window_size;
  u_int address_width;
  u_int options;
} VME_SlaveMap_t;

typedef struct 
{
  VME_SlaveMap_t  in;
  u_int           vme_address;
  u_int           used;
}VME_SlaveMapInt_t;

typedef struct 
{
  u_int kvirt_address;
  u_int offset;
  u_int data;
  u_int nbytes;
  u_int rw;
}VME_SingleCycle_t;

typedef struct 
{
  u_int dctl;         //Universe chain descriptor
  u_int dtbc;         //Universe chain descriptor
  u_int dla;          //Universe chain descriptor
  u_int reserved1;    //Universe chain descriptor
  u_int dva;          //Universe chain descriptor
  u_int reserved2;    //Universe chain descriptor
  u_int dcpp;         //Universe chain descriptor
  u_int reserved3;    //Universe chain descriptor
  u_int ref;          //used by the library
  u_int reserved4[7]; //the size of the whole structure has to be a multiple of 32 bytes
} VME_DmaChain_t;

typedef struct
{
  u_int handle;
  u_int pid;  
  u_int ctrl;
  u_int counter;
  u_int timeout;
  u_int index;
  int timeoutval;
} VME_DMAhandle_t;

typedef struct
{
  u_int nvectors;
  u_int vector[VME_MAXINTERRUPT];    // use int internally
  u_int level;			     // SAME for all vectors
  u_int type;			     // SAME for all vectors
} VME_IntHandle_t;

typedef struct
{
  u_int level;
  u_int type;
} VME_IntEnable_t;

typedef struct
{
  VME_IntHandle_t int_handle;
  int timeout;
  u_int level;
  u_int type;
  u_int vector;	// use int internally
  u_int multiple;
} VME_WaitInt_t;

typedef struct
{
  VME_IntHandle_t int_handle;
  int signum;
} VME_RegSig_t;

typedef struct
{
  u_int paddr;
  u_int handle;
} VME_DMAstart_t;

typedef struct
{
  u_int irq_mode[9];
} VME_Update_t;

typedef u_int   VME_ErrorCode_t;

typedef struct 
{
  u_int vmebus_address;
  u_int system_iobus_address;
  u_int size_requested;
  u_int control_word;
  u_int size_remaining;
  u_int status_word;
} VME_BlockTransferItem_t;

typedef struct
{
  u_char vector;
  u_int level;
  u_int type;
} VME_InterruptItem_t;

typedef struct 
{
  u_char vector;
  u_int level;
  u_int type;
  u_int multiple;
} VME_InterruptInfo_t;

typedef struct
{
  u_int vmebus_address;
  u_int address_modifier;
  u_int lword;
  u_int iack;
  u_int ds0;
  u_int ds1;
  u_int wr;
  int  multiple;
} VME_BusErrorInfo_t;

/********/
/*Macros*/
/********/
#ifdef __powerpc__
  #define BSWAP(x) bswap(x)
  #define SYNC __asm__("eieio")
#endif

#ifdef __i386__
  #define BSWAP(x) (x)
  #define SYNC
#endif

#endif
