/* ============================================================ 

FAD Data Display

Oliver Grimm, June 2010

============================================================ */

#include "GUI.h"

Qt::GlobalColor LineColors[] = {Qt::black, Qt::blue, Qt::red, Qt::green, Qt::white,
   	Qt::darkRed, Qt::darkGreen, Qt::darkBlue, Qt::cyan,	Qt::darkCyan, Qt::magenta, Qt::darkMagenta,
	Qt::gray, Qt::darkGray, Qt::lightGray};

fad::fad() {
  
  //---------------------------------------------------------------------
  //**************************** Main window ****************************
  //---------------------------------------------------------------------

  Central = new QWidget(this);
  setCentralWidget(Central);

  // Sockets
  for (int i=0; i<NUM_SOCKETS; i++) {
	Socket[i] = new QTcpSocket(Central);
	connect(Socket[i], SIGNAL(readyRead()), this, SLOT(ReadFromSocket()));   
	connect(Socket[i], SIGNAL(disconnected()), this, SLOT(GotDisconnected())); 
  }
   
  // Plot area
  Graph = new QwtPlot(Central);
  Graph->setAxisTitle(QwtPlot::yLeft, "Signal [V]");
  Graph->setAxisTitle(QwtPlot::xBottom, "time [ns]");
  Graph->setAutoReplot(true);
  Graph->setCanvasBackground(QColor(Qt::yellow));
  Graph->insertLegend(new QwtLegend(), QwtPlot::TopLegend, 0.3);

  Magnifier = new QwtPlotMagnifier(Graph->canvas());
  Magnifier->setMouseButton(Qt::NoButton,Qt::NoButton);
  Magnifier->setZoomInKey(Qt::Key_M, Qt::NoModifier);
  Magnifier->setZoomOutKey(Qt::Key_M, Qt::ShiftModifier);

  Zoomer = new QwtPlotZoomer(QwtPlot::xBottom,QwtPlot::yLeft,Graph->canvas());
  connect(Zoomer, SIGNAL(zoomed(const QwtDoubleRect &)), this, SLOT(HandleZoom(const QwtDoubleRect &)));

  Panner = new QwtPlotPanner(Graph->canvas());
  Panner->setMouseButton(Qt::LeftButton, Qt::ShiftModifier);

  Grid = new QwtPlotGrid;
  Grid->setMajPen(QPen(Qt::gray, 0, Qt::DotLine));
  Grid->attach(Graph);

  // Plot curves for all 36 channels
  for (int i=0; i<NUM_CHANNELS; i++) {
	Signal[i] = new QwtPlotCurve;
	Signal[i]->attach(Graph);
	Signal[i]->setStyle(QwtPlotCurve::Steps);
	Signal[i]->setTitle(QString("%1").arg(i));
	Signal[i]->setPen(QColor(LineColors[i % (sizeof(LineColors)/sizeof(Qt::GlobalColor))]));
  }

  // Layout of all widgets
  MainLayout = new QGridLayout(Central);
  MainLayout->addWidget(Graph, 1, 1, 6, 5);
  MainLayout->setColumnStretch(1, 10);
    
  // Menu bar
  QMenu* Menu = menuBar()->addMenu("&Menu");
  QAction* SaveAction = Menu->addAction("Save plot", this, SLOT(MenuSave()));
  SaveAction->setShortcut(Qt::CTRL + Qt::Key_S);
  Menu->addAction("Print plot", this, SLOT(MenuPrint()));
  Menu->addAction("Save waveform to ASCII", this, SLOT(MenuSaveASCII()));
  Menu->addSeparator();
  ConnectAction = Menu->addAction("Connect", this, SLOT(MakeConnection()));
  ConnectAction->setShortcut(Qt::CTRL + Qt::Key_C);
  QAction* QuitAction = Menu->addAction("Quit", qApp, SLOT(quit()));
  QuitAction->setShortcut(Qt::CTRL + Qt::Key_Q);
    
  //-----------------------------------------------------------------------
  //**************************** Socket window ****************************
  //-----------------------------------------------------------------------
  
  // Create widget (initially hidden)
  SocketWindow = new QWidget();
  SocketWindow->setWindowTitle("fad - Socket Interface");
 
  // Edit box for IP Address  
  IPAddress = new QLineEdit(SocketWindow);
	//IPAddress->setText("fadboard0");
	IPAddress->setText("129.217.160.119");
  IPAddress->setToolTip("Address of socket server");
  AddressLayout = new QFormLayout;
  AddressLayout->addRow("&Remote Address", IPAddress);
  
  // SpinBox for port selection
  Port = new QSpinBox(SocketWindow);
  Port->setRange(0,65535);
  Port->setValue(5000);
  Port->setToolTip("Port number of socket server");
  PortLayout = new QFormLayout;  
  PortLayout->addRow("&Port", Port);

  // Button to make connection
  Connect = new QPushButton("Connect", SocketWindow);
  Connect->setFont(QFont("Times", 10, QFont::Bold));
  connect(Connect, SIGNAL(clicked()), this, SLOT(MakeConnection()));
  Connect->setToolTip("Connect to server");
    
  // Edit box for command
  Command = new QLineEdit(SocketWindow);
  CommandLayout = new QFormLayout;  
  CommandLayout->addRow("&Command", Command);
  Command->setEnabled(false);
  connect(Command, SIGNAL(returnPressed()), this, SLOT(SendToSocket()));
  Command->setToolTip("Command to send to socket server");

  // Text box for socket output
  SocketOutput= new QPlainTextEdit(SocketWindow);
  SocketOutput->setReadOnly(true);
  SocketOutput->setMaximumBlockCount(MAX_OUTPUT_LINES);
  SocketOutput->setToolTip("Output of socket server");


	DRSgroupBox = new QGroupBox("DRS to be plotted", SocketWindow);
	for (int i =0 ; i<4; i++)
	{
		DRS[i] = new QCheckBox (SocketWindow);
	}
	DRS[0]->setChecked(true);

 	DRSBoxLayout = new QHBoxLayout;
	for (int i =0 ; i<4; i++)
	{
			DRSBoxLayout->addWidget(DRS[i]);
	}
 	//DRSBoxLayout->addStretch(1); // ??
 	DRSgroupBox->setLayout(DRSBoxLayout);	

	ChannelgroupBox = new QGroupBox("Channel to be plotted", SocketWindow);
	for (int i =0 ; i<9; i++)
	{
		ChannelCheckBox[i] = new QCheckBox (SocketWindow);
		ChannelCheckBox[i]->setChecked(true);
	}
	
 	ChannelBoxLayout = new QHBoxLayout;
	for (int i =0 ; i<9; i++)
	{
			ChannelBoxLayout->addWidget(ChannelCheckBox[i]);
	}
 	//ChannelBoxLayout->addStretch(1); // ??
 	ChannelgroupBox->setLayout(ChannelBoxLayout);	



  // Layout of all widgets
  SocketLayout = new QGridLayout(SocketWindow);
  SocketLayout->addLayout(AddressLayout, 0, 0, 0, 1);
  SocketLayout->addLayout(PortLayout, 0, 2);
  SocketLayout->addWidget(Connect, 0, 3);
  SocketLayout->addLayout(CommandLayout, 1, 0, 1, 6);
  SocketLayout->addWidget(SocketOutput, 2, 0, 4, 6);
  SocketLayout->addWidget(DRSgroupBox, 7, 0);
  SocketLayout->addWidget(ChannelgroupBox, 7, 1);
//	SocketLayout->addLayout(vbox, 0,6);

  SocketWindow->show();

}

fad::~fad() {

  delete Grid;			
  for (int i=0; i<NUM_CHANNELS; i++) delete Signal[i];

  delete PortLayout;
  delete CommandLayout;
  delete AddressLayout;
  delete SocketWindow;  
}


//---------------------------------------------------------------------
//**************************** Main program ***************************
//---------------------------------------------------------------------

int main(int argc, char *argv[]) {
  QApplication app(argc, argv);
  
  fad MainWindow;
  MainWindow.setGeometry(100, 100, 800, 500);
  MainWindow.setWindowTitle("fad - FAD Data Display");
  MainWindow.show();
  
  return app.exec();
}
