#ifndef EDD_H_SEEN
#define EDD_H_SEEN

#include <string>

#include <QtGui>
#include <QtNetwork/QTcpSocket>
#include <QtNetwork/QAbstractSocket>

#include <qwt_plot.h>
#include <qwt_plot_curve.h>
#include <qwt_plot_grid.h>
#include <qwt_plot_zoomer.h>
#include <qwt_plot_magnifier.h>
#include <qwt_plot_panner.h>
#include <qwt_raster_data.h>
#include <qwt_scale_widget.h>
#include <qwt_plot_layout.h>
#include <qwt_legend.h>

#define SOCKET_TIMEOUT 10000	// Milliseconds to wait for socket connection
#define MAX_OUTPUT_LINES 200	// Maximum number of lines in socket output window
#define MAX_COM_SIZE 30000
#define INITIAL_DIRECTORY ""

#define NUM_SOCKETS 8
#define NUM_CHANNELS 36

// Main window class
class fad : public QMainWindow {
    Q_OBJECT

    QPushButton *Connect;
    QLineEdit *IPAddress, *Command;
    QSpinBox *Port , *Channel;
    QPlainTextEdit *SocketOutput;
    QTcpSocket *Socket[NUM_SOCKETS];
    QWidget *SocketWindow, *Central;
    QAction *ConnectAction;

		QGroupBox *DRSgroupBox;
		QCheckBox *DRS[4];
		QHBoxLayout *DRSBoxLayout;

		QGroupBox *ChannelgroupBox ;
		QCheckBox *ChannelCheckBox[9] ;
		QHBoxLayout *ChannelBoxLayout;

    QGridLayout *SocketLayout, *MainLayout;
    QFormLayout *CommandLayout, *PortLayout, *AddressLayout , *ChannelLayout;
    
    QwtPlot *Graph;
    QwtPlotZoomer *Zoomer;
		QwtPlotMagnifier *Magnifier;
    QwtPlotCurve *Signal[NUM_CHANNELS];
    QwtPlotPanner *Panner;
    QwtPlotGrid *Grid;

    void closeEvent(QCloseEvent *); 

		QByteArray Data[NUM_SOCKETS];
    bool ManualDisconnect;
      
  public:
    fad();
    ~fad();
    
  private slots:
    void MakeConnection();
    void SendToSocket();
    void ReadFromSocket();
    void GotDisconnected();
    void HandleZoom(const QwtDoubleRect &);   
    void MenuSave();
    void MenuPrint();
    void MenuSaveASCII();
		// converts AD9238 adc code to double
    double ad9238ToDouble(unsigned short code);
		double ad9238ToDouble(short code); 
		int ad9238ToInt(short code);
};

#endif
