#ifndef PACKED_FORMATFAD_H_
#define PACKED_FORMATFAD_H_


typedef struct
{
	unsigned short start_package_flag;
	unsigned short package_length;
	unsigned short version_no;
	unsigned long trigger_id;
	unsigned char trigger_type;
	unsigned char trigger_crc;
	unsigned long local_trigger_id;
	unsigned char local_trigger_type;
	unsigned char local_trigger_crc;
	unsigned short board_id;
	short drs_temperature[4];
	unsigned short dac[8]; // new in version 0x0102
}  __attribute__((__packed__)) PEVNT_HEADER;

typedef struct
{
	unsigned short channel_id;
	unsigned short channel_start_cell;
	unsigned short channel_roi;
	unsigned short *channel_adc_data;
}  __attribute__((__packed__)) PCHANNEL;

typedef struct
{
	unsigned short channel_id;
	unsigned short channel_start_cell;
	unsigned short channel_roi;
}  __attribute__((__packed__)) PCHANNELHEADER;


typedef struct
{
	PEVNT_HEADER evnt_header;
	PCHANNEL channel[4 * 9];
	unsigned short package_crc;		// new in version 0x0101
	unsigned short end_package_flag;
}  __attribute__((__packed__)) PEVNT;

typedef struct
{
	unsigned short start_package_flag;
	unsigned short package_length;
	unsigned short version_no;
	unsigned long trigger_id;
	unsigned char trigger_type;
	unsigned char trigger_crc;
	unsigned long local_trigger_id;
	unsigned char local_trigger_type;
	unsigned char local_trigger_crc;
	unsigned short board_id;
	short drs_temperature[4];
	unsigned short dac[8]; // new in version 0x0102
}UPEVNT_HEADER;

typedef struct
{
	unsigned short channel_id;
	unsigned short channel_start_cell;
	unsigned short channel_roi;
	unsigned short *channel_adc_data;
}UPCHANNEL;

typedef struct
{
	unsigned short channel_id;
	unsigned short channel_start_cell;
	unsigned short channel_roi;
}UPCHANNELHEADER;


typedef struct
{
	UPEVNT_HEADER evnt_header;
	UPCHANNEL channel[4 * 9];
	unsigned short package_crc;		// new in version 0x0101
	unsigned short end_package_flag;
}UPEVNT;


#endif /*PACKED_FORMATFAD_H_*/
