//
// Generate status.xml for elogbook status display
//
// Copy executable to /srv/www/htdocs/FACTelog/bin/ and
// change owner to 'tomcat'.
//
// Oliver Grimm, 29/7/2010

#include <iostream>
#include <fstream>

#include "Evidence.h"


using namespace std;

int main() {

  string Status1, Status2, Status3, Status4, Status5;

  // Open file
  ofstream File("/srv/www/htdocs/FACTelog/jsp/status.xml");
  if (!File.is_open()) {
    cerr << "Could not open file for writing" << endl;
	exit (EXIT_FAILURE);
  }
  
  // Request data from DIM
  DimCurrentInfo Alarm("Alarm/MasterAlarm", NO_LINK);
  DimCurrentInfo FBState("Feedback/State", NO_LINK);
  DimCurrentInfo RunNumber("drsdaq/RunNumber", NO_LINK);
  DimCurrentInfo RunSize("drsdaq/RunSizeMB", NO_LINK);
  DimCurrentInfo EventNo("drsdaq/EventNumber", NO_LINK);

  // Feedback state
  if (!EvidenceServer::ServiceOK(&FBState)) Status1 = "Feedback state n/a";
  else Status1 = EvidenceServer::ToString((char *) "I:1;C", FBState.getData(), FBState.getSize()).substr(2);

  // MasterAlarm level
  if (!EvidenceServer::ServiceOK(&Alarm)) Status2 = "MasterAlarm n/a";
  else {
    switch (Alarm.getInt()) {
      case 0: Status2 = "OK"; break;
      case 1: Status2 = "Server WARN"; break;
      case 2: Status2 = "Server ERROR"; break;
      case 3: Status2 = "Server FATAL"; break;
      case 4: Status2 = "Server UNAVAILABLE"; break;
      default: Status2 = "MasterAlarm ???";
    }
  }

  // Run-related information 
  if (!EvidenceServer::ServiceOK(&RunNumber)) Status3 = "Run #n/a";
  else Status3 = "Run #" + EvidenceServer::ToString((char *) "I", RunNumber.getData(), RunNumber.getSize());
  
  if (!EvidenceServer::ServiceOK(&RunSize)) Status4 = "Size n/a";
  else Status4 = "Size " + EvidenceServer::ToString((char *) "F", RunSize.getData(), RunSize.getSize()) + " MB";

  if (!EvidenceServer::ServiceOK(&RunSize)) Status5 = "Event #n/a";
  else Status5 = "Event #" + EvidenceServer::ToString((char *) "I", EventNo.getData(), EventNo.getSize());
  
  // Write file
  File << "<status_info>" << endl;
  File << "<status_val1>" << Status1 << "</status_val1>" << endl;
  File << "<status_val2>" << Status2 << "</status_val2>" << endl;
  File << "<status_val3>" << Status3 << "</status_val3>" << endl;
  File << "<status_val4>" << Status4 << "</status_val4>" << endl;
  File << "<status_val5>" << Status5 << "</status_val5>" << endl;
  File << "<status_val6>" << " " << "</status_val6>" << endl;
  File << "</status_info>" << endl;
  
  // Close file
  File.close();
}
