/********************************************************************\

  inspectrawfile.cpp

  Reads DAQ raw data file and prints run and event headers and data.
  Main purpose is to demonstrate the procedure to read raw files.
  
  Oliver Grimm

\********************************************************************/

#include <stdlib.h>
#include <limits.h>
#include "RawDataCTX.h"

int main(int argc, char *argv[]) {

  int NumEvents, NumBins, EventCount=0;

  // Check command line syntax
  if (argc<2 || argc>4) {
    printf("Usage: %s <rawfile> [Number of events to display] [Number of data bins to display]\n", argv[0]);
    exit(EXIT_SUCCESS);
  }

  NumEvents = argc>2 ? atoi(argv[2]) : INT_MAX;
  RawDataCTX *RD = new RawDataCTX();

  // Open data file, read and print run header, and loop through all events
  if (RD->OpenDataFile(argv[1], stdout) != CTX_OK) {
    printf("Error accessing file: %s\n", argv[1]);
  }
  else {
    NumBins = argc==4 && atoi(argv[3])<RD->RHeader->Samples ? atoi(argv[3]) : RD->RHeader->Samples;
    
    while (EventCount++ < NumEvents && RD->ReadEvent(0,stdout) == CTX_OK) {
      printf("Trigger cells: ");
      for (int i=0; i<RD->RHeader->NBoards*RD->RHeader->NChips; i++) {
        printf("%d ", *((int *) RD->Data + i));
      }
      for(int i=0; i<RD->RHeader->NBoards; i++) {
        for(int j=0; j<RD->RHeader->NChips*RD->RHeader->NChannels; j++) {
	  if (NumBins>0) printf("\nBoard %d, channel %d\t", i,j);
	  for(int k=0; k<NumBins ; k++)
	    printf("%.1f ",*((short *) (RD->Data + RD->RHeader->NBoards*RD->RHeader->NChips*sizeof(int)) + i*RD->RHeader->NChips*RD->RHeader->NChannels*RD->RHeader->Samples +
	     j*RD->RHeader->Samples+k)*RD->BStruct[i].ScaleFactor);
        }
      }
      printf("\n\n");
    }
  }
  
  delete RD;
  return EXIT_SUCCESS;
}
  
