#include <QtNetwork/QTcpSocket>
#include <QtNetwork/QAbstractSocket>
#include <QWidget>
#include <QtGui>
#include "tpixel.h"
#include "tempsens.h"
#include "humidity.h"
#include <QString>
#define SOCKET_TIMEOUT 10000	// Milliseconds to wait for socket connection
#define MAX_OUTPUT_LINES 200	// Maximum number of lines in socket output window
#define MAX_COM_SIZE 10000
#define INITIAL_DIRECTORY ""

 class MyWidget : public QWidget
 {

   Q_OBJECT
     Tpixel **pixels;
   Tempsens **tempsens;
   Humidity **humidity;
 public:
   int* PixelToTriggerPixel;
   int* ListToTemperaturePixel;
  MyWidget( QWidget *parent=0 );
   QTcpSocket *Socket;
   QPlainTextEdit *RunHeaderDisplay, *EventHeaderDisplay, *SocketOutput;
   QSpinBox *Port;
   QLineEdit *IPAddress,*Command;
   QWidget *SocketWindow;
   QFormLayout *CommandLayout, *PortLayout, *AddressLayout;
   QPushButton *GetButton, *SocketButton, *Connect;
   QGridLayout *SocketLayout;
   QAction *ConnectAction;
 private:
   void ParseData(QString data);
   bool WaitForData,ManualDisconnect;
   private slots:
     void OpenSocketWindow();
   void GetSignalFromSocket();
   void MakeConnection();
   void SendToSocket();
   void ReadFromSocket();
    void GotDisconnected();
    void updateRates();
    /*  void MenuAbout();*/
};


