/********************************************/
/*Header file for the CAEN V560             */
/*16 Channel scaler                         */
/*        
/*Author: Michael Rissi
/*Date: 29 May 2009                         */
/*Based on v792.h by Markus Joos            */
/********************************************/

#ifndef _V560_H
#define _V560_H

//******************************************************************************
//Constants
//******************************************************************************

#define V560_CHANNELS 16
#include "rcc_error/rcc_error.h"
#include "vme_rcc/vme_rcc.h"
//******************************************************************************
//Type definitions
//******************************************************************************

//This struct maps the memory of a v560 module.
typedef struct {
  //	Variable name							//Adress offset		//Read-/Write-Mode
  u_short dummy1[2];         	                                        //0x00-0x04			// none
  u_short interrupt_vector_register;					//0x04-0x06			// r/w
  u_short interrupt_level_register;				        //0x06-0x08			// r/w
  u_short enable_VME_interrupt;              				//0x08-0x0A			// r/w
  u_short disable_VME_interrupt;		         		//0x0A-0x0C			// r/w
  u_short clear_VME_interrupt;           				//0x0C-0x0E			// r/w
  u_short request_register;              				//0x0E-0x10			// r/w
  u_int counter[V560_CHANNELS];                  			//0x10-0x50			// r
  u_short scale_clear;                    				//0x50-0x52			// r/w
  u_short VME_veto_set; 						//0x52-0x54			// r/w
  u_short VME_veto_reset; 						//0x54-0x56			// r/w
  u_short scale_increase; 						//0x56-0x58			// r/w
  u_short scale_status_register;					//0x58-0x5A			// r/w
   u_short dummy2[80];                                                   //0x5A-0xF8			// not used
  u_short fixed_code;            					//0xFA-0xFC			// r
  u_short manufacturer_type;           					//0xFC-0xFE			// r
  u_short version_series;           					//0xFE   			// r 
} v560_registers_t;

//This struct contains the information necessary to handle one module
typedef struct {
	v560_registers_t* registers;		//contains the virtual address of the module
	int master_mapping;					//contains the handle of the module
	char present;						//0 if module not present, 1 if present
} v560_module_t;

//******************************************************************************
//Global Variables
//******************************************************************************

v560_module_t v560_modules[]; //TODO: not sure if this is correct

//******************************************************************************
//Function Definitions
//******************************************************************************

VME_ErrorCode_t V560_Open();
int V560_Send_Scale_Increment(short module);
int V560_Set_Veto(short module);
int V560_Reset_Veto(short module);
int V560_Clear_Scales(short module);
u_short V560_Read_Request_Register(short module);
int V560_Write_Request_Register(short module,short request);
int V560_Clear_VME_Interrupt(short module);
int V560_Read_Counter(short module, short channel);
//int V560_Set_Threshold(u_short module, u_char channel, u_short threshold);
/*extern int V560_Set_Pattern_Inhibit(u_short module, u_char channel[16]);
extern int V560_Set_Output_Width(u_short module, u_char channel_block, u_short width);
extern int V560_Set_Dead_Time(u_short module, u_char channel_block, u_short dead_time);
extern int V560_Set_Majority_Level(u_short module, u_short majority_level);
extern int V560_Test_Pulse(u_short module);*/
int V560_Print_Info(void);
VME_ErrorCode_t V560_Close(void);

//******************************************************************************

#endif
