#include <stdio.h>
#include "rcc_error/rcc_error.h"
#include "vme_rcc/vme_rcc.h"

//******************************************************************************
//Constants
//******************************************************************************

#define NMAX_V560_MODULES 10 //maximum 65535, probably more than enough...
#define V560_CHANNELS 16

//******************************************************************************
//Type definitions
//******************************************************************************

//This struct maps the memory of a v560 module.
typedef struct {
//	Variable name							//Adress offset		//Read-/Write-Mode
	u_short threshold_ch[V560_CHANNELS];	//0x00-0x1E			//w
	u_short dummy1[16];						//0x20-0x3E			//none
	u_short output_width[2];				//0x40-0x42			//w
	u_short dead_time[2];					//0x44-0x46			//w
	u_short majority_threshold;				//0x48				//w
	u_short pattern_inhibit;				//0x4A				//w
	u_short test_pulse;						//0x4C				//w
	u_short dummy2[86];						//0x4E-0xF8			//none
	u_short fixed_code;						//0xFA				//r
	u_short manufacturer_type;				//0xFC				//r
	u_short version_serialnumber;			//0xFE				//r
} v560_registers_t;

//This struct contains the information necessary to handle one module
typedef struct {
	v560_registers_t* registers;		//contains the virtual address of the module
	int master_mapping;					//contains the handle of the module
	char present;						//0 if module not present, 1 if present
} v560_module_t;

//******************************************************************************
//Global Variables
//******************************************************************************

v560_module_t v560_modules[NMAX_V560_MODULES];

//******************************************************************************
//Function Definitions
//******************************************************************************

VME_ErrorCode_t V560_Open(void)
{
	printf("V560_Open() was called.\n");
	return VME_SUCCESS;
}

//******************************************************************************

int V560_Set_Threshold(u_short module, u_char channel, u_short threshold)
{
	printf("V560_Set_Threshold(module %i, channel %i, threshold %i) was called.\n", module, channel, threshold);
	return 0;
}

//******************************************************************************

int V560_Set_Pattern_Inhibit(u_short module, u_char channels[16])
{
	//create the pattern of inhibit
	u_short pattern = 0;
	int i;
	for(i=0; i<16; i++) {
		if(channels[i]!=0) {
			switch(i) {
				case 0: pattern |= 0x0001; break;
				case 1: pattern |= 0x0002; break;
				case 2: pattern |= 0x0004; break;
				case 3: pattern |= 0x0008; break;
				case 4: pattern |= 0x0010; break;
				case 5: pattern |= 0x0020; break;
				case 6: pattern |= 0x0040; break;
				case 7: pattern |= 0x0080; break;
				case 8: pattern |= 0x0100; break;
				case 9: pattern |= 0x0200; break;
				case 10: pattern |= 0x0400; break;
				case 11: pattern |= 0x0800; break;
				case 12: pattern |= 0x1000; break;
				case 13: pattern |= 0x2000; break;
				case 14: pattern |= 0x4000; break;
				case 15: pattern |= 0x8000; break;
			}
		}
	}
	printf("v560_pattern_inhibit(module %i, pattern %04x) was called.\n", module, pattern);
	return 0;
}

//******************************************************************************

int V560_Set_Output_Width(u_short module, u_char channel_block, u_short width)
{
	printf("V560_Set_Output_Width(module %i, channel block %i, width %i) was called.\n", module, channel_block, width);
	return 0;
}

//******************************************************************************

int V560_Set_Dead_Time(u_short module, u_char channel_block, u_short dead_time)
{
	printf("V560_Set_Dead_Time(module %i, channel block %i, dead time %i) was called.\n", module, channel_block, dead_time);
	return 0;
}

//******************************************************************************

int V560_Set_Majority_Level(u_short module, u_short majority_level)
{
	printf("V560_Set_Majority_Level(module %i, majority_level %i) was called.\n", module, majority_level);
	return 0;
}

//******************************************************************************

int V560_Test_Pulse(u_short module)
{
	printf("V560_Test_Pulse(module %i) was called.\n", module);
	return 0;
}

//******************************************************************************

int V560_Print_Info(void)
{
	printf("V560_Print_Info() was called.\n");
	return 0;
}

//******************************************************************************

VME_ErrorCode_t V560_Close(void)
{
	printf("V560_Close() was called.\n");
	return VME_SUCCESS;
}

//******************************************************************************
