-- VHDL Entity FACT_FAD_TB_lib.fad_main_tb.symbol
--
-- Created:
--          by - dneise.UNKNOWN (TU-CC4900F8C7D2)
--          at - 15:53:42 30.06.2010
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY fad_main_tb IS
-- Declarations

END fad_main_tb ;

--
-- VHDL Architecture FACT_FAD_TB_lib.fad_main_tb.struct
--
-- Created:
--          by - dneise.UNKNOWN (TU-CC4900F8C7D2)
--          at - 15:53:42 30.06.2010
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;

LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.all;
USE ieee.std_logic_textio.all;
LIBRARY std;
USE std.textio.all;

LIBRARY FACT_FAD_lib;
LIBRARY FACT_FAD_TB_lib;

ARCHITECTURE struct OF fad_main_tb IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL CLK_25_PS      : std_logic;
   SIGNAL CLK_50         : std_logic;
   SIGNAL RSRLOAD        : std_logic                    := '0';
   SIGNAL SRCLK          : std_logic                    := '0';
   SIGNAL SROUT_in_0     : std_logic;
   SIGNAL SROUT_in_1     : std_logic;
   SIGNAL SROUT_in_2     : std_logic;
   SIGNAL SROUT_in_3     : std_logic;
   SIGNAL adc_data       : std_logic_vector(11 DOWNTO 0);
   SIGNAL adc_data_array : adc_data_array_type;
   SIGNAL adc_oeb        : std_logic;
   SIGNAL adc_otr        : STD_LOGIC;
   SIGNAL adc_otr_array  : std_logic_vector(3 DOWNTO 0);
   SIGNAL board_id       : std_logic_vector(3 DOWNTO 0);
   SIGNAL clk            : STD_LOGIC;
   SIGNAL crate_id       : std_logic_vector(1 DOWNTO 0);
   SIGNAL dac_cs         : std_logic;
   SIGNAL denable        : std_logic                    := '0';                -- default domino wave off
   SIGNAL drs_channel_id : std_logic_vector(3 DOWNTO 0) := (others => '0');
   SIGNAL drs_dwrite     : std_logic                    := '1';
   SIGNAL led            : std_logic_vector(7 DOWNTO 0) := (OTHERS => '0');
   SIGNAL mosi           : std_logic                    := '0';
   SIGNAL sclk           : std_logic;
   SIGNAL sensor_cs      : std_logic_vector(3 DOWNTO 0);
   SIGNAL sio            : std_logic;
   SIGNAL trigger        : std_logic;
   SIGNAL wiz_addr       : std_logic_vector(9 DOWNTO 0);
   SIGNAL wiz_cs         : std_logic                    := '1';
   SIGNAL wiz_data       : std_logic_vector(15 DOWNTO 0);
   SIGNAL wiz_int        : std_logic;
   SIGNAL wiz_rd         : std_logic                    := '1';
   SIGNAL wiz_reset      : std_logic                    := '1';
   SIGNAL wiz_wr         : std_logic                    := '1';


   -- Component Declarations
   COMPONENT FAD_main
   GENERIC (
      RAMADDRWIDTH64b : integer := 12
   );
   PORT (
      CLK            : IN     std_logic ;
      SROUT_in_0     : IN     std_logic ;
      SROUT_in_1     : IN     std_logic ;
      SROUT_in_2     : IN     std_logic ;
      SROUT_in_3     : IN     std_logic ;
      adc_data_array : IN     adc_data_array_type ;
      adc_otr_array  : IN     std_logic_vector (3 DOWNTO 0);
      board_id       : IN     std_logic_vector (3 DOWNTO 0);
      crate_id       : IN     std_logic_vector (1 DOWNTO 0);
      trigger        : IN     std_logic ;
      wiz_int        : IN     std_logic ;
      CLK_25_PS      : OUT    std_logic ;
      CLK_50         : OUT    std_logic ;
      RSRLOAD        : OUT    std_logic                     := '0';
      SRCLK          : OUT    std_logic                     := '0';
      adc_oeb        : OUT    std_logic                     := '1';
      dac_cs         : OUT    std_logic ;
      denable        : OUT    std_logic                     := '0';           -- default domino wave off
      drs_channel_id : OUT    std_logic_vector (3 DOWNTO 0) := (others => '0');
      drs_dwrite     : OUT    std_logic                     := '1';
      led            : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      mosi           : OUT    std_logic                     := '0';
      sclk           : OUT    std_logic ;
      sensor_cs      : OUT    std_logic_vector (3 DOWNTO 0);
      wiz_addr       : OUT    std_logic_vector (9 DOWNTO 0);
      wiz_cs         : OUT    std_logic                     := '1';
      wiz_rd         : OUT    std_logic                     := '1';
      wiz_reset      : OUT    std_logic                     := '1';
      wiz_wr         : OUT    std_logic                     := '1';
      sio            : INOUT  std_logic ;
      wiz_data       : INOUT  std_logic_vector (15 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT adc_emulator
   GENERIC (
      INPUT_FILE : string := "filename"
   );
   PORT (
      clk  : IN     STD_LOGIC ;
      data : OUT    STD_LOGIC_VECTOR (11 DOWNTO 0);
      otr  : OUT    STD_LOGIC ;
      oeb  : IN     STD_LOGIC 
   );
   END COMPONENT;
   COMPONENT clock_generator
   GENERIC (
      clock_period : time := 20 ns;
      reset_time   : time := 50 ns
   );
   PORT (
      clk : OUT    std_logic  := '0';
      rst : OUT    std_logic  := '0'
   );
   END COMPONENT;
   COMPONENT max6662_emulator
   GENERIC (
      DRS_TEMPERATURE : integer := 51
   );
   PORT (
      sclk      : IN     std_logic ;
      sio       : INOUT  std_logic ;
      sensor_cs : IN     std_logic_vector (3 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT trigger_generator
   GENERIC (
      TRIGGER_RATE : time := 1 ms;
      PULSE_WIDTH  : time := 20 ns
   );
   PORT (
      trigger : OUT    std_logic 
   );
   END COMPONENT;
   COMPONENT w5300_emulator
   PORT (
      addr : IN     std_logic_vector (9 DOWNTO 0);
      data : INOUT  std_logic_vector (15 DOWNTO 0);
      rd   : IN     std_logic ;
      wr   : IN     std_logic 
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : FAD_main USE ENTITY FACT_FAD_lib.FAD_main;
   FOR ALL : adc_emulator USE ENTITY FACT_FAD_TB_lib.adc_emulator;
   FOR ALL : clock_generator USE ENTITY FACT_FAD_TB_lib.clock_generator;
   FOR ALL : max6662_emulator USE ENTITY FACT_FAD_TB_lib.max6662_emulator;
   FOR ALL : trigger_generator USE ENTITY FACT_FAD_TB_lib.trigger_generator;
   FOR ALL : w5300_emulator USE ENTITY FACT_FAD_TB_lib.w5300_emulator;
   -- pragma synthesis_on


BEGIN
   -- Architecture concurrent statements
   -- HDL Embedded Text Block 1 eb_mainTB_ID
   -- eb_ID 1: hard-wired IDs
   board_id <= "0101";
   crate_id <= "01";

   -- HDL Embedded Text Block 2 eb_mainTB_adc
   -- eb_adc 2: ADC routing
   adc_data_array(0) <= adc_data;
   adc_data_array(1) <= adc_data;
   adc_data_array(2) <= adc_data;
   adc_data_array(3) <= adc_data;
   adc_otr_array(0) <= adc_otr;
   adc_otr_array(1) <= adc_otr;
   adc_otr_array(2) <= adc_otr;
   adc_otr_array(3) <= adc_otr;


   -- Instance port mappings.
   I_mainTB_FPGA : FAD_main
      GENERIC MAP (
         RAMADDRWIDTH64b => 15
      )
      PORT MAP (
         CLK            => clk,
         SROUT_in_0     => SROUT_in_0,
         SROUT_in_1     => SROUT_in_1,
         SROUT_in_2     => SROUT_in_2,
         SROUT_in_3     => SROUT_in_3,
         adc_data_array => adc_data_array,
         adc_otr_array  => adc_otr_array,
         board_id       => board_id,
         crate_id       => crate_id,
         trigger        => trigger,
         wiz_int        => wiz_int,
         CLK_25_PS      => CLK_25_PS,
         CLK_50         => CLK_50,
         RSRLOAD        => RSRLOAD,
         SRCLK          => SRCLK,
         adc_oeb        => adc_oeb,
         dac_cs         => dac_cs,
         denable        => denable,
         drs_channel_id => drs_channel_id,
         drs_dwrite     => drs_dwrite,
         led            => led,
         mosi           => mosi,
         sclk           => sclk,
         sensor_cs      => sensor_cs,
         wiz_addr       => wiz_addr,
         wiz_cs         => wiz_cs,
         wiz_rd         => wiz_rd,
         wiz_reset      => wiz_reset,
         wiz_wr         => wiz_wr,
         sio            => sio,
         wiz_data       => wiz_data
      );
   I_mainTB_adc : adc_emulator
      GENERIC MAP (
         INPUT_FILE => "../memory_files/analog_input_ch0.txt"
      )
      PORT MAP (
         clk  => clk,
         data => adc_data,
         otr  => adc_otr,
         oeb  => adc_oeb
      );
   I_mainTB_clock : clock_generator
      GENERIC MAP (
         clock_period => 20 ns,
         reset_time   => 50 ns
      )
      PORT MAP (
         clk => clk,
         rst => OPEN
      );
   I_mainTB_max6662 : max6662_emulator
      GENERIC MAP (
         DRS_TEMPERATURE => 51
      )
      PORT MAP (
         sclk      => sclk,
         sio       => sio,
         sensor_cs => sensor_cs
      );
   I_mainTB_trigger : trigger_generator
      GENERIC MAP (
         TRIGGER_RATE => 1 ms,
         PULSE_WIDTH  => 20 ns
      )
      PORT MAP (
         trigger => trigger
      );
   I_mainTB_w5300 : w5300_emulator
      PORT MAP (
         addr => wiz_addr,
         data => wiz_data,
         rd   => wiz_rd,
         wr   => wiz_wr
      );

END struct;
