----------------------------------------------------------------------------------
-- Company:        ETH Zurich, Institute for Particle Physics
-- Engineer:       P. Vogler, Q. Weitzel
-- 
-- Create Date:    08/06/2010
-- Design Name:    
-- Module Name:    FTU_control - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:    Control FSM of FACT FTU board 										
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

library ftu_definitions;
USE ftu_definitions.ftu_array_types.all;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity FTU_control is
  port(
    clk_50MHz    : IN  std_logic;
    clk_ready    : IN  std_logic;
    config_ready : IN std_logic;
    reset        : OUT std_logic;
    config_start : OUT std_logic
  );
end FTU_control;

architecture Behavioral of FTU_control is

  signal reset_sig : STD_LOGIC := '0';

  signal config_start_sig : STD_LOGIC := '0';
  signal config_ready_sig : STD_LOGIC := '0';
  
  type FTU_control_StateType is (IDLE, INIT, RUNNING, RESET_ALL);
  signal FTU_control_State, FTU_control_NextState: FTU_control_StateType;
  
begin
   
  --FTU control state machine (two-process implementation)

  FTU_control_Registers: process (clk_50MHz)
  begin
    if Rising_edge(clk_50MHz) then
      FTU_control_State <= FTU_control_NextState;
    end if;
  end process FTU_control_Registers;

  FTU_control_C_logic: process (FTU_control_State, clk_ready, config_ready_sig)
  begin
    FTU_control_NextState <= FTU_control_State;
    case FTU_control_State is
      when IDLE =>                      -- wait for DMCs to lock
        reset_sig <= '0';
        config_start_sig <= '0';
        --ram_web_sig <= "0";
        if (clk_ready = '1') then
          FTU_control_NextState <= RUNNING;
        end if;          
      when INIT =>                      -- load default config data to RAM 
        reset_sig <= '0';
        config_start_sig <= '0';
        --ram_web_sig <= "1";
        --ram_adb_cntr <= ram_adb_cntr + 1;
        --ram_adb_sig <= conv_std_logic_vector(ram_adb_cntr, 4);        
        --if (ram_adb_cntr < 4) then
        --  ram_dib_sig <= DEFAULT_ENABLE(ram_adb_cntr);
        --  FTU_top_NextState <= INIT;
        --elsif (ram_adb_cntr < 4 + 5) then
        --  ram_dib_sig <= conv_std_logic_vector(DEFAULT_DAC(ram_adb_cntr - 4), 16);
        --  FTU_top_NextState <= INIT;
        --elsif (ram_adb_cntr < 32) then
        --  ram_dib_sig <= (others => '0');
        --  FTU_top_NextState <= INIT;
        --else
        --  ram_adb_cntr <= 0;
        --  ram_web_sig <= "0";
        --  FTU_top_NextState <= RUNNING;
        --end if;
      when RUNNING =>                   -- count triggers and react to commands
        reset_sig <= '0';
        config_start_sig <= '0';
        --ram_web_sig <= "0";
      when RESET_ALL =>                     -- reset/clear and start from scratch
        reset_sig <= '1';
        config_start_sig <= '0';
        --ram_web_sig <= "0";
        FTU_control_NextState <= IDLE;
    end case;
  end process FTU_control_C_logic;

  reset <= reset_sig;
  
end Behavioral;
