-- File:     upcnt16.vhd
--
-- Purpose:  Up 16-bit counter
--
-- Created:  7-25-00 ALS
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;

entity upcnt16 is
  port(
    full  : out STD_LOGIC;
    clr   : in  STD_LOGIC;
    reset : in  STD_Logic;
    clk   : in  STD_LOGIC
  );

end upcnt16;

architecture DEFINITION of upcnt16 is

  constant RESET_ACTIVE : std_logic := '0';
  constant Cnt_full     : Unsigned (15 DOWNTO 0) :="1111111111111111";
  
  signal q : Unsigned (15 DOWNTO 0);

begin
  
  process(clk, reset, clr)
  begin
    
    if ((reset OR clr)='1') then
      q <= (others => '0');-- Clear output register      
    elsif (clk'event) and clk = '1' and (not(q = Cnt_full)) then-- On rising edge of clock count
      q <= q + 1;
    end if;
    
  end process;
  
  process(q)
  begin
    
    if (q = Cnt_full) then
      full <= '1';
    else
      full <= '0';
    end if;
    
  end process;

end DEFINITION;
