-- File:     upcnt5.vhd
-- 
-- Author:   Jennifer Jenkins
-- Purpose:  Up 5-bit counter
--
-- Created:  5-3-99 JLJ
-- Revised:  6-15-99 ALS

---------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------
--  Modified by Patrick Vogler
--  18th November 2009
--
--  Counter width extended from 4 to 5 bit in order to extend the SPI interface from
--  8 to 16 bit word size
--
--	 Modifications are marked by: *Mod: <modification>
--
--  Cleaned up by Quirin Weitzel
--  21th January 2010
---------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;

entity upcnt5 is --*Mod: 4 to 5 bit
  port(    
    cnt_en       : in STD_LOGIC;                        -- Count enable          -- Load line enable
    clr          : in STD_LOGIC;                        -- Active low clear
    clk          : in STD_LOGIC;                        -- Clock
    qout         : inout STD_LOGIC_VECTOR (4 downto 0)  --*Mod: 4 to 5 bit
  );        
end upcnt5;

architecture DEFINITION of upcnt5 is

constant RESET_ACTIVE : std_logic := '0';

signal q_int : UNSIGNED (4 downto 0);  --*Mod: 4 to 5 bit

begin

  process(clk, clr)
  begin  
    -- Clear output register
    if (clr = RESET_ACTIVE) then
      q_int <= (others => '0');
      -- On falling edge of clock count
    elsif (clk'event) and clk = '1' then
      if cnt_en = '1' then
        q_int <= q_int + 1;
      end if;
    end if;
  end process;

  qout <= STD_LOGIC_VECTOR(q_int);

end DEFINITION;
