--------------------------------------------------------------------------------
-- Company:       ETH Zurich, Institute for Particle Physics
-- Engineer:      P. Vogler, Q. Weitzel
--
-- Create Date:   07/14/2010
-- Design Name:   
-- Module Name:   FTU_test5_tb.vhd
-- Project Name:  
-- Target Device:  
-- Tool versions:  
-- Description:   Testbench for test5 entity of FACT FTU board 
-- 
-- VHDL Test Bench Created by ISE for module: FTU_test5
-- 
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends
-- that these types always be used for the top-level I/O of a design in order
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--
-- based on testbench for FTU_test1
--
--------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use IEEE.NUMERIC_STD.ALL;
 
entity FTU_test5_tb is
end FTU_test5_tb;

architecture behavior of FTU_test5_tb is 

  -- Component Declaration for the Unit Under Test (UUT)
 
  component FTU_test5
    port(
      -- global control
      ext_clk   : IN  STD_LOGIC;                      -- external clock from FTU board
      --reset     : in  STD_LOGIC;                      -- reset
      brd_add   : IN  STD_LOGIC_VECTOR(5 downto 0);   -- geographic board/slot address
      brd_id    : IN  STD_LOGIC_VECTOR(7 downto 0);   -- local solder-programmable address

      -- rate counters LVDS inputs
      -- use IBUFDS differential input buffer
      patch_A_p     : IN  STD_LOGIC;                  -- logic signal from first trigger patch
      patch_A_n     : IN  STD_LOGIC;
      patch_B_p     : IN  STD_LOGIC;                  -- logic signal from second trigger patch
      patch_B_n     : IN  STD_LOGIC;
      patch_C_p     : IN  STD_LOGIC;                  -- logic signal from third trigger patch
      patch_C_n     : IN  STD_LOGIC;
      patch_D_p     : IN  STD_LOGIC;                  -- logic signal from fourth trigger patch
      patch_D_n     : IN  STD_LOGIC;
      trig_prim_p   : IN  STD_LOGIC;                  -- logic signal from n-out-of-4 circuit
      trig_prim_n   : IN  STD_LOGIC;

      -- DAC interface
      -- miso          : IN  STD_LOGIC;                  -- master-in-slave-out
      sck           : OUT STD_LOGIC;                  -- serial clock to DAC
      mosi          : OUT STD_LOGIC;                  -- serial data to DAC, master-out-slave-in
      clr           : OUT STD_LOGIC;                  -- clear signal to DAC
      cs_ld         : OUT STD_LOGIC;                  -- chip select or load to DAC

      -- RS-485 interface to FTM
      rx            : IN  STD_LOGIC;                  -- serial data from FTM
      tx            : OUT STD_LOGIC;                  -- serial data to FTM
      rx_en         : OUT STD_LOGIC;                  -- enable RS-485 receiver
      tx_en         : OUT STD_LOGIC;                  -- enable RS-485 transmitter

      -- analog buffer enable
      enables_A   : OUT STD_LOGIC_VECTOR(8 downto 0);  -- individual enables for analog inputs
      enables_B   : OUT STD_LOGIC_VECTOR(8 downto 0);  -- individual enables for analog inputs
      enables_C   : OUT STD_LOGIC_VECTOR(8 downto 0);  -- individual enables for analog inputs
      enables_D   : OUT STD_LOGIC_VECTOR(8 downto 0);  -- individual enables for analog inputs

      -- testpoints
      TP_A       : out STD_LOGIC_VECTOR(11 downto 0)   -- testpoints
    );
  end component;
    
  --Inputs
  signal ext_clk     : STD_LOGIC := '0';
  --signal reset       : STD_LOGIC := '0';
  signal brd_add     : STD_LOGIC_VECTOR(5 downto 0) := "000001";
  signal brd_id      : STD_LOGIC_VECTOR(7 downto 0) := (others => '0');
  signal patch_A_p   : STD_LOGIC := '0';
  signal patch_A_n   : STD_LOGIC := '0';
  signal patch_B_p   : STD_LOGIC := '0';
  signal patch_B_n   : STD_LOGIC := '0';
  signal patch_C_p   : STD_LOGIC := '0';
  signal patch_C_n   : STD_LOGIC := '0';
  signal patch_D_p   : STD_LOGIC := '0';
  signal patch_D_n   : STD_LOGIC := '0';
  signal trig_prim_p : STD_LOGIC := '0';
  signal trig_prim_n : STD_LOGIC := '0';
  -- signal miso        : STD_LOGIC := '0';
  signal rx          : STD_LOGIC := '0';

  --Outputs
  signal enables_A : STD_LOGIC_VECTOR(8 downto 0);
  signal enables_B : STD_LOGIC_VECTOR(8 downto 0);
  signal enables_C : STD_LOGIC_VECTOR(8 downto 0);
  signal enables_D : STD_LOGIC_VECTOR(8 downto 0);
  signal clr       : STD_LOGIC;
  signal cs_ld     : STD_LOGIC;
  signal sck       : STD_LOGIC;
  signal mosi      : STD_LOGIC;
  signal tx        : STD_LOGIC;
  signal rx_en     : STD_LOGIC;
  signal tx_en     : STD_LOGIC;
  signal TP_A      : STD_LOGIC_VECTOR(11 downto 0);
  
  -- Clock period definitions
  constant ext_clk_period : TIME := 20 ns;
 
begin
 
  -- Instantiate the Unit Under Test (UUT)
  uut: FTU_test5
    port map(
      ext_clk     => ext_clk,
      --reset       => reset,
      brd_add     => brd_add,
      brd_id      => brd_id,
      patch_A_p   => patch_A_p,
      patch_A_n   => patch_A_n,
      patch_B_p   => patch_B_p,
      patch_B_n   => patch_B_n,
      patch_C_p   => patch_C_p,
      patch_C_n   => patch_C_n,
      patch_D_p   => patch_D_p,
      patch_D_n   => patch_D_n,
      trig_prim_p => trig_prim_p,
      trig_prim_n => trig_prim_n,
      -- miso        => miso,
      rx          => rx,
      rx_en       => rx_en,
      enables_A   => enables_A,
      enables_B   => enables_B,
      enables_C   => enables_C,
      enables_D   => enables_D,
      clr         => clr,
      cs_ld       => cs_ld,
      sck         => sck,
      mosi        => mosi,
      tx          => tx,
      tx_en       => tx_en,
      TP_A        => TP_A
    );

  -- Clock process definitions
  ext_clk_proc: process
  begin
    ext_clk <= '0';
    wait for ext_clk_period/2;
    ext_clk <= '1';
    wait for ext_clk_period/2;
  end process ext_clk_proc;
 
  -- Stimulus process
  stim_proc: process
  begin		
    -- hold reset state for 100ms.
    wait for 100ms;	
    
    wait for ext_clk_period*10;

    -- insert stimulus here 

    wait;
  end process stim_proc;

end;
