--
-- VHDL Architecture FACT_FAD_lib.adc_buffer.beha
--
-- Created:
--          by - kai.UNKNOWN (E5PCXX)
--          at - 14:57:55 04.05.2010
--
-- using Mentor Graphics HDL Designer(TM) 2009.1 (Build 12)
--
library ieee;
use ieee.std_logic_1164.all;
use IEEE.STD_LOGIC_ARITH.all;
use ieee.STD_LOGIC_UNSIGNED.all;

library fact_fad_lib;
use fact_fad_lib.fad_definitions.all;

library UNISIM;
use UNISIM.VComponents.all;
USE IEEE.NUMERIC_STD.all;
USE IEEE.std_logic_signed.all;

ENTITY adc_buffer IS
   PORT(
      clk_ps             : IN     std_logic; 
      adc_data_array     : IN     adc_data_array_type;
      adc_otr_array      : IN     std_logic_vector (3 DOWNTO 0);
      adc_data_array_int : OUT    adc_data_array_type;
      adc_otr            : OUT    std_logic_vector (3 DOWNTO 0)
   );

-- Declarations

END adc_buffer ;

--
ARCHITECTURE beha OF adc_buffer IS
BEGIN
  adc_buf : process (clk_ps)
  begin
    if rising_edge (clk_ps) then
      adc_data_array_int <= adc_data_array;
      adc_otr <= adc_otr_array;
    end if;
  end process adc_buf;
END ARCHITECTURE beha;

