----------------------------------------------------------------------------------
-- Company:        ETH Zurich, Institute for Particle Physics
-- Engineer:       Q. Weitzel
-- 
-- Create Date:    14:09:39 07/12/2010 
-- Design Name: 
-- Module Name:    FTU_clk_gen - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:    interface to different DCMs and clk dividers for FTU board
--                 add here more DCMs if needed
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity FTU_clk_gen is
  Port (
    clk    : IN  STD_LOGIC;
    rst    : IN  STD_LOGIC;
    clk_50 : OUT STD_LOGIC;
    ready  : OUT STD_LOGIC
  );
end FTU_clk_gen;

architecture Behavioral of FTU_clk_gen is

  component FTU_dcm_50M_to_50M
    port (
      CLKIN_IN        : in    std_logic;
      RST_IN          : in    std_logic;
      CLKFX_OUT       : out   std_logic;
      CLKIN_IBUFG_OUT : out   std_logic;
      LOCKED_OUT      : out   std_logic);
  end component;
  
begin

  Inst_FTU_dcm_50M_to_50M : FTU_dcm_50M_to_50M
    port map(
      CLKIN_IN        => clk,
      RST_IN          => rst,
      CLKFX_OUT       => clk_50,
      CLKIN_IBUFG_OUT => open,
      LOCKED_OUT      => ready
    );
  
end Behavioral;

