----------------------------------------------------------------------------------
-- Company:        ETH Zurich, Institute for Particle Physics
-- Engineer:       P. Vogler, Q. Weitzel
-- 
-- Create Date:    07/14/2010
-- Design Name:    
-- Module Name:    FTU_test5 - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:    Test firmware for FTU board, set thresholds and enables 										
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
library ftu_definitions_test5;
USE ftu_definitions_test5.ftu_array_types.all;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;


entity FTU_test5 is
  port(
    -- global control 
    ext_clk   : IN  STD_LOGIC;                      -- external clock from FTU board
    brd_add   : IN  STD_LOGIC_VECTOR(5 downto 0);   -- geographic board/slot address
    brd_id    : in  STD_LOGIC_VECTOR(7 downto 0);   -- local solder-programmable board ID

    -- rate counters LVDS inputs
    -- use IBUFDS differential input buffer
    patch_A_p     : IN  STD_LOGIC;                  -- logic signal from first trigger patch
    patch_A_n     : IN  STD_LOGIC;           
    patch_B_p     : IN  STD_LOGIC;                  -- logic signal from second trigger patch
    patch_B_n     : IN  STD_LOGIC;
    patch_C_p     : IN  STD_LOGIC;                  -- logic signal from third trigger patch
    patch_C_n     : IN  STD_LOGIC;
    patch_D_p     : IN  STD_LOGIC;                  -- logic signal from fourth trigger patch
    patch_D_n     : IN  STD_LOGIC;
    trig_prim_p   : IN  STD_LOGIC;                  -- logic signal from n-out-of-4 circuit
    trig_prim_n   : IN  STD_LOGIC;
    
    -- DAC interface
    sck           : OUT STD_LOGIC;                  -- serial clock to DAC
    mosi          : OUT STD_LOGIC;                  -- serial data to DAC, master-out-slave-in
    clr           : OUT STD_LOGIC;                  -- clear signal to DAC
    cs_ld         : OUT STD_LOGIC;                  -- chip select or load to DAC
    
    -- RS-485 interface to FTM
    rx            : IN  STD_LOGIC;                  -- serial data from FTM
    tx            : OUT STD_LOGIC;                  -- serial data to FTM
    rx_en         : OUT STD_LOGIC;                  -- enable RS-485 receiver
    tx_en         : OUT STD_LOGIC;                  -- enable RS-485 transmitter

    -- analog buffer enable
    enables_A   : OUT STD_LOGIC_VECTOR(8 downto 0);  -- individual enables for analog inputs
    enables_B   : OUT STD_LOGIC_VECTOR(8 downto 0);  -- individual enables for analog inputs
    enables_C   : OUT STD_LOGIC_VECTOR(8 downto 0);  -- individual enables for analog inputs
    enables_D   : OUT STD_LOGIC_VECTOR(8 downto 0);  -- individual enables for analog inputs

    -- testpoints
    TP_A        : out STD_LOGIC_VECTOR(11 downto 0)   -- testpoints    
  );
end FTU_test5;


architecture Behavioral of FTU_test5 is

  component FTU_test5_dac_dcm
    port(
      CLKIN_IN        : IN  STD_LOGIC; 
      RST_IN          : IN  STD_LOGIC; 
      CLKFX_OUT       : OUT STD_LOGIC; 
      CLKIN_IBUFG_OUT : OUT STD_LOGIC; 
      LOCKED_OUT      : OUT STD_LOGIC
    );
  end component;
  
  component FTU_test5_dac_control
    port(
      clk      : IN  STD_LOGIC;
      reset    : IN  STD_LOGIC;
      dacs     : IN  dac_array_type;
      clr      : OUT STD_LOGIC;
      mosi     : OUT STD_LOGIC;
      sck      : OUT STD_LOGIC;
      cs_ld    : OUT STD_LOGIC
    );
  end component;

  signal reset_sig : STD_LOGIC := '0';  -- initialize reset to 0 at power up 
  signal clk_50M_sig : STD_LOGIC;

  --signal enable_sig : enable_array_type := DEFAULT_ENABLE;
  signal enable_sig    : enable_array_type;
  signal dac_array_sig : dac_array_type;

  type FTU_test5_StateType is (Running);
  signal FTU_test5_State, FTU_test5_NextState: FTU_test5_StateType;
  
begin

  Inst_FTU_test5_dac_dcm : FTU_test5_dac_dcm
    port map(
      CLKIN_IN => ext_clk,
      RST_IN => reset_sig,
      CLKFX_OUT => clk_50M_sig,
      CLKIN_IBUFG_OUT => open,
      LOCKED_OUT => open
    );
  
  Inst_FTU_test5_dac_control : FTU_test5_dac_control
    port map(
      clk     => clk_50M_sig,
      reset   => reset_sig,
      dacs    => dac_array_sig,
      clr     => clr,
      mosi    => mosi,
      sck     => sck,
      cs_ld   => cs_ld
    );

  enable_sig <= ("0000000000000000","0000000000000000","0000000000000000","0000000000000000") when (brd_add(3 downto 0) = "0000") else
                ("0000000101010101","0000000101010101","0000000101010101","0000000101010101") when (brd_add(3 downto 0) = "0001") else
                ("0000000010101010","0000000010101010","0000000010101010","0000000010101010") when (brd_add(3 downto 0) = "0010") else
                ("0000000000000001","0000000000000001","0000000000000001","0000000000000001") when (brd_add(3 downto 0) = "0011") else
                ("0000000000000011","0000000000000011","0000000000000011","0000000000000011") when (brd_add(3 downto 0) = "0100") else
                ("0000000000001111","0000000000001111","0000000000001111","0000000000001111") when (brd_add(3 downto 0) = "0101") else
                ("0000000000111111","0000000000111111","0000000000111111","0000000000111111") when (brd_add(3 downto 0) = "0110") else
                ("0000000111111111","0000000111111111","0000000111111111","0000000111111111") when (brd_add(3 downto 0) = "0111") else
                ("0000000111110000","0000000111110000","0000000111110000","0000000111110000") when (brd_add(3 downto 0) = "1000") else
                ("0000000000011111","0000000000011111","0000000000011111","0000000000011111") when (brd_add(3 downto 0) = "1001") else
                DEFAULT_ENABLE;

  dac_array_sig <= (100,100,100,100,0,0,0,100) when (brd_add(5 downto 4) = "00") else
                   (200,200,200,200,0,0,0,100) when (brd_add(5 downto 4) = "01") else
                   (300,300,300,300,0,0,0,100) when (brd_add(5 downto 4) = "10") else
                   DEFAULT_DAC;
    
  enables_A <= enable_sig(0)(8 downto 0);
  enables_B <= enable_sig(1)(8 downto 0);
  enables_C <= enable_sig(2)(8 downto 0);
  enables_D <= enable_sig(3)(8 downto 0);
  
  --FTU main state machine (two-process implementation)

  FTU_test5_Registers: process (ext_clk)
  begin
    if Rising_edge(ext_clk) then
      FTU_test5_State <= FTU_test5_NextState;
    end if;
  end process FTU_test5_Registers;

  FTU_test5_C_logic: process (FTU_test5_State)
  begin
    FTU_test5_NextState <= FTU_test5_State;
    case FTU_test5_State is
      when Running =>
        reset_sig <= '0';
    end case;
  end process FTU_test5_C_logic;
  
end Behavioral;
