----------------------------------------------------------------------------------
-- Company:        ETH Zurich, Institute for Particle Physics
-- Engineer:       P. Vogler, Q. Weitzel
-- 
-- Create Date:    07/14/2010 
-- Design Name: 
-- Module Name:    FTU_test5_dac_control - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:     
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
library ftu_definitions_test5;
USE ftu_definitions_test5.ftu_array_types.all;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity FTU_test5_dac_control is
  port(
    clk      : IN     STD_LOGIC;
    reset    : IN     STD_LOGIC;
    dacs     : IN     dac_array_type;
    clr      : OUT    STD_LOGIC;
    mosi     : OUT    STD_LOGIC;
    sck      : OUT    STD_LOGIC;
    cs_ld    : out    STD_LOGIC
  );
end FTU_test5_dac_control;

architecture Behavioral of FTU_test5_dac_control is

  component FTU_test5_spi_interface
    port(
      clk_50MHz      : IN     std_logic;
      config_start   : IN     std_logic;
      dac_array      : IN     dac_array_type;
      config_ready   : OUT    std_logic;
      config_started : OUT    std_logic;
      dac_cs         : OUT    std_logic;
      mosi           : OUT    std_logic;
      sclk           : OUT    std_logic;
      miso           : INOUT  std_logic
   );
  end component;

  signal clk_sig            : std_logic;
  signal reset_sig          : std_logic;

  signal clr_sig            : std_logic;
  signal mosi_sig           : std_logic := '0';
  signal serial_clock_sig   : std_logic;
  signal dac_cs_sig         : std_logic;
  
  signal config_start_sig   : std_logic := '0';  
  signal config_ready_sig   : std_logic;
  signal config_started_sig : std_logic := '0';
  --signal dac_array_sig      : dac_array_type := DEFAULT_DAC;
  signal dac_array_sig      : dac_array_type;
  
  -- Build an enumerated type for the state machine
  type state_type is (START, WAITING, STOP);

  -- Register to hold the current state
  signal dac_ctrl_state, next_state : state_type;
  
begin

  reset_sig <= reset;
  clk_sig <= clk;
  mosi <= mosi_sig;
  sck <= serial_clock_sig;
  cs_ld <= dac_cs_sig;
  dac_array_sig <= dacs;
  
  -- FSM for dac control: first process
  FSM_Registers: process(clk_sig, reset_sig)
  begin
    if reset_sig = '1' then
      dac_ctrl_state <= START;
    elsif Rising_edge(clk_sig) then
      dac_ctrl_state <= next_state;
    end if;
  end process;

  -- FSM for dac control: second process
  FSM_logic: process(dac_ctrl_state, config_ready_sig)
  begin
    next_state <= dac_ctrl_state;
    case dac_ctrl_state is
      when START =>
        config_start_sig <= '1';
        next_state <= WAITING;        
      when WAITING =>
        config_start_sig <= '1';
        if (config_ready_sig = '1') then          
          next_state <= STOP;          
        else
          next_state <= WAITING;
        end if;
      when STOP =>
        config_start_sig <= '0';
    end case;
  end process;
    
  Inst_FTU_test5_spi_interface : FTU_test5_spi_interface
    port map(
      clk_50MHz      => clk_sig,
      config_start   => config_start_sig,
      dac_array      => dac_array_sig,
      config_ready   => config_ready_sig,
      config_started => config_started_sig,
      dac_cs         => dac_cs_sig,
      mosi           => mosi_sig,
      sclk           => serial_clock_sig,
      miso           => open
    );

end Behavioral;
