#define MAX_NUMBER_OF_OPENED_TCP_SOCKETS 100

/*
OpenSockets opens NumberOfSockets TCP Sockets.
a pointer to an array of SocketDescriptors is returned.
In case of error, the NULL pointer is returned.

In order to Close the Sockets and free memory call
void CloseSockets(int * SocketDescriptors, unsigned int NumberOfSockets);
*/
int * OpenSockets(unsigned int NumberOfSockets);

/*
	EmptySockets is used to read as much data from the TCP-Sockets in question
	as possible. After waiting "timeout_usec" (default 125ms) -- see header file
	without any data beeing present, the Socket is assumed to be empty.
	
	Hopefully it is.
	
	return is true if there was no error during the select statement.
	false if select returned <0, which should not happen at all.
	What to do if this happened?
	*/
	#define WASTEBIN_SIZE 1000
bool EmptySockets(int *SocketDescriptor, int NumberOfDescriptors, long timeout_usec = 125000L);

/*
	GetMaxFileDescriptor returns the value of the maximal
	filedescriptor from NumberOfSockets SocketDescriptors.
	The maximal filedescriptor + 1 is needed for select().
*/
int GetMaxFileDescriptor(unsigned int NumberOfSockets, int *SocketDescriptor);

/*
Connect2Server connects NumberOfSockets TCP Sockets
defined by SocketDescriptor
to host defined by ServerIPaddress
starting at Port StartPort, by adding 1 to each Socket

return value is NumberOfSockets if successful
it is zero if no Server was found and negative 
when connecting didn't work.
The negative magnitude indicates which connection didn't work
*/
int Connect2Server(	int *SocketDescriptor, 
											unsigned int NumberOfSockets,  
											unsigned int StartPort , 
											char *ServerIPaddress , 
											int verbose = 0);
											
											
/*
CloseSockets closes NumberOfSockets TCP Sockets
indicated by SocketDescriptor and frees the associated memory.
*/
int CloseSockets (int * SocketDescriptor , 
									unsigned int NumberOfSockets);

									
int * OpenServerSockets (unsigned int NumberOfSockets, unsigned int StartPort) ;

