#include <stdio.h>

#include <stdlib.h>
#include <cstdlib>

#include <iostream>

#include <sys/socket.h>
#include <arpa/inet.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

#include <string.h>
#include <sstream>
#include <signal.h>
#include <sys/socket.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <time.h>

#include "fadfake.h"

#include "../SocketFunctions/SocketFunctions.h"
#include "../format_headers/packed_formatfad.h"

using namespace std;

int fadfake() {
	int ReadResult;
	unsigned long triggerID=0;
	int *Sockets;
	timeval timeout;
	int select_return;
	fd_set ReadFileDescriptor;

	unsigned short Command[80];

	Sockets = OpenServerSockets (8, 5000) ;


		while(1){

			
			// Try to read command from socket
			memset(Command, 0xAA, sizeof(Command));
			ReadResult = read(Sockets[0], Command, MAX_COM_SIZE);
			cout << "just read sometinhg." << endl;
			if (ReadResult==0) break; // Client does not exist anymore
			if (ReadResult==-1) {
				printf("Error read from socket \n");
				break;
			}
			if (ntohs(Command[0]) == CMD_Start)
			{
				printf ("# -> Start Run\n");
			}	
			else if (ntohs(Command[0]) == CMD_Stop)
			{
				printf ("# -> Stop Run\n");
			}

			else if (ntohs(Command[0]) == 0x0000)
			{
				printf ("# -> received 0x0000\n");
			}

			else if (ntohs(Command[0]) == CMD_Trigger)
			{
				printf ("# -> Single Trigger\n");
				sendEvent(Sockets[0],triggerID,1024);
				++triggerID;
				printf ("Event %ld nach Socket %d gesendet\n\n", triggerID,0);
			}

			else if (ntohs(Command[0]) == CMD_Trigger_C)
			{
				printf ("# -> Continuous Trigger\n");
				while(true){
					fflush (stdout);
					FD_ZERO (&ReadFileDescriptor);
					FD_SET (Sockets[0], &ReadFileDescriptor);
					timeout.tv_sec = 0;
					timeout.tv_usec = 1000;
					sendEvent(Sockets[0],triggerID,1024);
					++triggerID;
					printf ("Event nach Socket %d gesendet\n", 0);
					select_return=select (((int) Sockets[0]) + 1 , &ReadFileDescriptor, NULL, NULL, &timeout); 
					if (select_return < 0){
						fprintf(stderr, "error: select returned %d.\n" , select_return );
					}
					if (FD_ISSET (Sockets[0], &ReadFileDescriptor)){						
						ReadResult = read(Sockets[0], Command, MAX_COM_SIZE);
					}	
					if (ReadResult <= 0) {
						fprintf(stderr, "error: read returned %d.\n", ReadResult);
					}		
					else if (ntohs(Command[0]) == CMD_Trigger_S)
					{
						printf ("# -> Stop Trigger\n");
						break;
					}	

				}
			}
			else if (ntohs(Command[0]) == CMD_Trigger_S)
			{
				printf ("# -> Stop Trigger\nThere was no Continious Trigger.\n");
			}
			else printf("# -> Command not supported.\n");

		}



CloseSockets (Sockets, 8);
return 0;
}


int sendEvent(int socketd, unsigned long triggerID, int ROI) {
cout << "I am here: triggerID: " << triggerID << endl;
	
	// we need to generate an Eventheader
	PEVNT_HEADER head;
	// as well as 36 channels
	PCHANNELHEADER chead;
	//	First we will fill the header
	// 	in order to be able to send it directly 
	//  I will hton() everything.

	head.start_package_flag = hton((unsigned short)(0xFB01));
	head.package_length = hton((unsigned short)(130+36*ROI+2));
	head.version_no = hton((unsigned short)(0x0102));
	head.trigger_id = hton((unsigned long)(triggerID));
	head.trigger_type = hton((unsigned char)(0x55));
	head.trigger_crc = hton((unsigned char)(0xAA));
	head.local_trigger_id = hton((unsigned long)(triggerID));
	head.local_trigger_type = hton((unsigned char)(0x55));
	head.local_trigger_crc = hton((unsigned char)(0xAA));
	head.board_id = hton((unsigned short)(0x0123));
	for (int i=0; i<4; ++i){	
		head.drs_temperature[i] = hton(short(10+i));
	}
	for (int i=0; i<8; ++i){	
		head.dac[i] = hton((unsigned short)(i));
	}

	//	now I will send the header.
	write (socketd, &head, sizeof(PEVNT_HEADER)); 
	cout << "header was sent away "  << endl;

	// next I will generate some channel data
	// and send it in a loop
	for (int ch=0; ch<9; ++ch) {	
		for (int drs=0; drs<4; ++drs) {
			chead.channel_id = hton((unsigned short)(ch*0xFF00+drs));
			chead.channel_start_cell = hton((unsigned short)(0));
			chead.channel_roi = hton((unsigned short)(ROI));

			unsigned short *data;
			data = (unsigned short *) malloc( ROI * sizeof(unsigned short) );

			for (int cell = 0; cell < ROI; ++cell){
//			data[(cell+20*(ch+drs*11))/2] = hton((unsigned short)(cell/(drs+1)));
			data[cell] = hton((unsigned short)(cell+20*(drs*9+ch)));
			}
			write (socketd, &chead, sizeof(PCHANNELHEADER));
			write (socketd, data, ROI*sizeof(unsigned short));
				cout << "channel was sent away DRS:" << drs<<" CH:" << ch  << endl;
		}
	}

	// now I should better not forget to send the package end as well
	unsigned short package_crc=hton((unsigned short)(0x1234));		// new in version 0x0101
	unsigned short end_package_flag=hton((unsigned short)(0x04FE));

	write (socketd, &package_crc, sizeof(unsigned short));
	write (socketd, &end_package_flag, sizeof(unsigned short));
 

	return 0;
}
