#ifndef FADFAKE_H
#define FADFAKE_H

#define MAX_COM_SIZE 10000

// Commands for FAD
#define CMD_Start 0xC000
#define CMD_Stop 0x3000
#define CMD_Trigger 0xA000 		// single trigger
#define CMD_Trigger_C 0xB000 	// continous trigger
#define CMD_Trigger_S 0x2000 	// stop continous trigger
#define CMD_Read 0x0A00 		// read from Config-RAM
#define CMD_Write 0x0500 		// write ro Config-RAM

// Addresses in FAD Config-RAM
#define MAX_ADDR 0xFF // highest address in Config-RAM
#define BADDR_ROI 0x00 // Baseaddress ROI-Values
#define BADDR_DAC 0x24 // Baseaddress DAC-Values

#define MAX_VAL 65535
#define MAX_ROINUM 35
#define MAX_ROIVAL 1024
#define MAX_DACNUM 7
#define MAX_DACVAL 65535


#include "../format_headers/formatfad.h"
#include "../format_headers/formatraw.h"

int fadfake() ;
int sendEvent(int socketd, unsigned long triggerID, int ROI) ;

	template < typename T >
		T hton(T value)
		{
			T d=0; //dummy variable	
			if ( sizeof(T)==4 )
			{
				d = htonl(value);
			} 
			else if (sizeof(T)==2 )
			{
				d = htons(value);
			}
			else // if char or any other data type, I hope endianess is no problem :-|
			{
				// nothing
			}
			return d;
		}

	template < typename T >
		T ntoh(T value)
		{
			T d=0; //dummy variable	
			if ( sizeof(T)==4 )
			{
				d = ntohl(value);
			} 
			else if (sizeof(T)==2 )
			{
				d = ntohs(value);
			}
			else // if char or any other data type, I hope endianess is no problem :-|
			{
				// nothing
			}
			return d;
		}


#endif
