/********************************************************************\

  rawtoroot.cc

  Reads rawfile created by the CTX DAQ.
  Run using '.x rawtoroot.cc++("raw-filename")'.
  Generate shared library using make, then load library in root
  with gSystem->Load("RawDataCTX.so")
  
	Dominik Neise
  based on rootread.cc by Oliver Grimm

\********************************************************************/

#include <stdlib.h>
#include <iostream>

#include <TCanvas.h>
#include <TH1.h>
#include <TTree.h>
#include <TFile.h>
#include <TTimer.h>
#include <Getline.h>
#include <TLegend.h>

#include <string.h>
#include "../../drsdaq/RawDataCTX.h"

void rawtoroot(char* Filename) {


	string c=Filename;
	c.replace(c.length()-3,3,"root");

	TFile *myf = new TFile(c.c_str(),"RECREATE","Demo ROOT file with histograms & trees");

  #ifdef __CINT__
  printf("Error: This script can only be executed via ACliC\n");
  return;
  #endif

  RawDataCTX *RD = new RawDataCTX();

  // Open data file and read run header
  if (RD->OpenDataFile(Filename, NULL) != CTX_OK) {
    delete RD;
    return;
  }

  // ...for convenience some abbrevations
  unsigned int Boards = RD->RHeader->NBoards;
  unsigned int Channels = RD->RHeader->NChips*RD->RHeader->NChannels;
  unsigned int Samples = RD->RHeader->Samples;
	if (Samples != 1024) {
		cout << "Error: ROI is not 1024, but data is shifted according to physical pipeline. Makes no sense." << endl;
	}
 
 	int stopcell;
	unsigned int channel,drs,Eventnumber,channelindex;

	  TH1F* hist = new TH1F();


		TTree *tree = new TTree("T","event data tree");

		tree->Branch("drs",&drs,"drs/I");									// from 0 .. 3
		tree->Branch("channel",&channel,"channel/I"); 						// from 0 .. 8
		tree->Branch("channelindex", &channelindex, "channelindex/I");		// from 0 .. 35
		tree->Branch("hist","TH1F",&hist);
		tree->Branch("samples",&Samples,"samples/I");						// size of ROI
		
		// note: not the real Eventnumber from RAW file is used
		// TODO
		tree->Branch("Eventnumber", &Eventnumber, "Eventnumber/I");			// Eventnumber 0..N 
		
		// the data is shifted, which makes only sense for ROI=samples=1024
		tree->Branch("stopcell", &stopcell, "stopcell/I");
	
int num=0;

  // Read and display all events
  while (RD->ReadEvent(0, stdout) == CTX_OK) {
		Eventnumber = num;
    int *TrigPnt = (int *) RD->Data;

		// apparently it is necessary to step back 8 byte ... I don't know why, but it works.
    short *DataPnt = (short *) RD->Data + (Boards*RD->RHeader->NChips)*sizeof(int) - 8	* sizeof(char);
    
    printf("Trigger cells: ");
    for(unsigned int i=0; i<Boards*RD->RHeader->NChips; i++) printf("%d ", *(TrigPnt + i));
    printf("\n");
     
		for(unsigned int k=0; k<Boards; k++) {
			for(unsigned int j=0; j<Channels; j++) {	
			  TH1F* a = new TH1F();				
				a->SetBins(Samples, -0.5, Samples-0.5);
				a->SetLineColor(1);
				a->SetLineWidth(2);
				a->SetLineStyle(1);
				a->GetXaxis()->SetTitle(Form("Time slice (%.1f ns/slice)", 1./RD->BStruct[k].NomFreq));
				a->GetYaxis()->SetTitle("Amplitude (a.u.)");
				drs = j/9;
				channel = j%9;
				channelindex = j;				
				stopcell =  *(TrigPnt + drs);
				for(unsigned int i=0; i<Samples ; i++) {
		          a->SetBinContent((i+stopcell)%Samples+1, DataPnt[k*Channels*Samples + j*Samples + i] * RD->BStruct[k].ScaleFactor);
				}
				
				
				hist=a;
				tree->Fill();
				delete a;
      }
    }
 
		++num;
  }

		tree->BuildIndex("Eventnumber", "channelindex");

		myf->Write();
		myf->Close();
		delete RD;
}
