
#ifndef PROCESSIO_H_SEEN
#define PROCESSIO_H_SEEN

#include <stdarg.h>
#include <errno.h>
#include <math.h>
#include <signal.h>
#include <string>
#include <pthread.h>
#include <limits>

#define SERVER_NAME "Bias"       // Name to use in DIM
#include "Evidence.h"

#include "Crate.h"
#include "../pixelmap/PixelMap.h"

#define MAX_COM_SIZE 5000

#define MIN_RATE 0.01
#define MAX_RATE 50.0

class ProcessIO: public EvidenceServer {

	PixelMap *pm;
	DimCommand *DIMCommand;
	DimService *ConsoleOut;
	char *ConsoleText;
	pthread_t Thread;
	std::vector<std::string> Parameter;

	std::vector<class Crate *> Crates;

	void commandHandler();

 public:
	double fTimeOut;
	float fStatusRefreshRate;
	unsigned int fMaxDiff;

	ProcessIO();
	~ProcessIO();

	void PrintMessage(const char *, ...);
	bool RampVoltage(unsigned int, int, int, int);
	void Monitor();
	static void LaunchMonitor(ProcessIO *);
	
	void cmd_hv();
	void cmd_status();
	void cmd_load();	void cmd_save();
	void cmd_exit();	void cmd_rate();
	void cmd_timeout();	void cmd_reset();
	void cmd_help();
};

struct Range {
  int Min;
  int Max;
};

bool Match(std::string, const char *);
bool ConvertToDouble(std::string, double *);
bool ConvertToInt(std::string, int *);
struct Range ConvertToRange(std::string);

#endif
