/********************************************************************\

  Read SOCKETS_PER_FAD Channels from FAD-Board
  Write Commands to Socket 0, Commands must be (n * 16) Bit long
  
  Usage: SocketClient [IP-Address]
  
  kw, 05.10
  
  based on:
  Generic example for remote control via a socket interface

  Oliver Grimm, March 2009

\********************************************************************/
#ifndef PATH_MAX
#define PATH_MAX 1000
#endif
#include "simple_daq.h"
#include "../SocketFunctions/SocketFunctions.h"

#include "iostream"

int revision = atoi(REVISION) * (strchr(REVISION,'M')==NULL ? 1:-1);
int fad_firmware_revision;

int init_fad();
int get_firmware_revision();
int *SocketDescriptor;
using namespace std;

int main(int argc, char *argv[])
{
	// what kind of buffer is this?
	char Buffer[MAX_COM_SIZE];
	
	int read_return;

	fd_set ReadFileDescriptor;
	int max_fd = 0;
	
	FILE* outfile[SOCKETS_PER_FAD];
	char outfilename[PATH_MAX];

	
		SimpleDaqConfiguration *conf;
	// Get configuration file path from command line
	// Get configurarion from configurationfile.
	// such as FAD IP Adress
	if (argc > 1)
	{
		conf = getConfig(argv[1]);
	} else {
		conf = getConfig(CONFIG_FILE_PATH);
	}
	
	// Open sockets
	SocketDescriptor = OpenSockets(SOCKETS_PER_FAD);
	if (SocketDescriptor == NULL) {
		exit_program (EXIT_FAILURE);
	}
	max_fd = GetMaxFileDescriptor(SOCKETS_PER_FAD, SocketDescriptor);
	
	// Connect to server
	if( Connect2Server(	SocketDescriptor, SOCKETS_PER_FAD, FIRST_DAQPORT, conf->FADIPAddress, 1) != SOCKETS_PER_FAD) {
			// Connect2Server prints some error messages in case of exceptions...
			printf ("Error in Connect2Server()\n");
			exit_program (EXIT_FAILURE);
	}

	// Open files for output
	for (int i = 0; i < SOCKETS_PER_FAD; i++)
	{
		sprintf (outfilename, "%s/%s-%d.%s", conf->outfilepath, conf->outfilename, i, conf->outfileext);
		if ((outfile[i] = fopen (outfilename, "w")) == NULL)
		{
			printf ("Error: Could not open file %s\n", outfilename);
			exit_program (EXIT_FAILURE);
		}
	}
	
	init_fad();
	
	fad_firmware_revision = get_firmware_revision();	
	printf ("software revision is: %s or %d\n",REVISION,revision);
	printf ("firmware revision is: %d\n",fad_firmware_revision);
	
	
	



	signal (SIGPIPE, SIG_IGN); // Do not kill process if writing to closed socket
	signal (SIGINT, int_handler); // Cleanup after SIGINT (CTRL-C)

//	init_fad();
//	fflush (stdin);
	// Main loop
	while (true)
	{
		fflush (stdout);

		FD_ZERO (&ReadFileDescriptor);		
		FD_SET(STDIN_FILENO, &ReadFileDescriptor);
		for (int i = 0; i < SOCKETS_PER_FAD; i++)
		{
			FD_SET (SocketDescriptor[i], &ReadFileDescriptor);
		}

		// Wait for data from sockets
		if (select (((int) max_fd) + 1, &ReadFileDescriptor, NULL, NULL, NULL) == -1)
		{
			perror ("Error with select()\n");
			break;
		}
		
		memset (Buffer, 0, sizeof (Buffer));
 

		// init board -- should be switchable 
		// with a commandline switch, but ... 
		// TODO


		// Data from STDIN
		if (FD_ISSET (STDIN_FILENO, &ReadFileDescriptor))
		{
			fgets (Buffer, MAX_COM_SIZE, stdin);
			// Send command to socket 0
			cmd_send (Buffer, SocketDescriptor[0]);			
		}
		// Data from sockets
		else
		{
			// Check all sockets
			for (int i = 0; i < SOCKETS_PER_FAD; i++)
			{
				if (FD_ISSET (SocketDescriptor[i], &ReadFileDescriptor))
				{ 
					// Only for testing
					memset (Buffer, 0xAA, sizeof (Buffer));
					if ((read_return = read (SocketDescriptor[i], Buffer, MAX_COM_SIZE)) == 0)
					{
						printf ("Error: Server not existing anymore, exiting...\n");
						exit_program (EXIT_FAILURE);
					}
	
					if (read_return > 0)
					{
						printf ("Socket [%d]: Read %d Bytes\n", i, read_return);
					
						fwrite (Buffer, 1, (size_t) read_return, outfile[i]);
						// Important!!!
						fflush (outfile[i]);
					}
				}
			}
		}
	} // while (TRUE)

	exit (EXIT_SUCCESS);
}

// close sockets and exit
void exit_program (int exit_status)
{	
	printf ("\nClosing Sockets...");
	for (int i = 0; i < SOCKETS_PER_FAD; i++)
	{
		close (SocketDescriptor[i]);
	}
	printf (" done\n");


	
	exit (exit_status);
}

// SIGINT
void int_handler (int sig)
{
	exit_program (EXIT_SUCCESS);
}


// note: verbose is not used, but anyway defined.
SimpleDaqConfiguration *getConfig (const char *path, int verbose) {
FILE* ConfigFile;
// try to open config file
// if not exists return NULL
ConfigFile = fopen (path, "r");
if (ConfigFile == NULL) {
	return NULL;
}

//create SimpleDaqConfiguration
SimpleDaqConfiguration *conf = new SimpleDaqConfiguration();

// read config data from file and fill in SimpleDaqConfiguration
fscanf( ConfigFile , "%s" , conf->FADIPAddress );
fscanf( ConfigFile , "%s" , conf->outfilepath );
fscanf( ConfigFile , "%s" , conf->outfilename );
fscanf( ConfigFile , "%s" , conf->outfileext );

return conf;
}

int init_fad(){
	cmd_send ("ds\n", SocketDescriptor[0]);			
	cmd_send ("dd\n", SocketDescriptor[0]);				
sleep (1);
	cmd_send ("sd 0 21000\n", SocketDescriptor[0]);
	cmd_send ("sd 1 0\n", SocketDescriptor[0]);
	cmd_send ("sd 2 5000\n", SocketDescriptor[0]);
	cmd_send ("sd 3 5000\n", SocketDescriptor[0]);
	cmd_send ("sd 4 28800\n", SocketDescriptor[0]);
	cmd_send ("sd 5 28800\n", SocketDescriptor[0]);
	cmd_send ("sd 6 28800\n", SocketDescriptor[0]);
	cmd_send ("sd 7 28800\n", SocketDescriptor[0]);

sleep (1);
	cmd_send ("sra 10\n", SocketDescriptor[0]);
	cmd_send ("sa 44 29\n", SocketDescriptor[0]);			
sleep (1);
	cmd_send ("t\n", SocketDescriptor[0]);			
sleep (1);
	cmd_send ("sa 44 30\n", SocketDescriptor[0]);			
sleep (1);
	cmd_send ("t\n", SocketDescriptor[0]);			
sleep (1);
	cmd_send ("sa 44 0\n", SocketDescriptor[0]);			
sleep (1);
	cmd_send ("t\n", SocketDescriptor[0]);
	cmd_send ("sclkoff\n", SocketDescriptor[0]);			
	cmd_send ("de\n", SocketDescriptor[0]);			
	cmd_send ("dr\n", SocketDescriptor[0]);			
	cmd_send ("sra 1024\n", SocketDescriptor[0]);			
sleep (1);

	EmptySockets(SocketDescriptor, 8, 750000L);



	printf (	"\n\n FAD initialised. \n "
						"ROI is 1024. \n"
						"DRS shift registers are initialised.\n"
						"DRS is up and running.\n"
						"SPI SCLK was swithced off, TEMP readout makes no sense.\n" 
						"DAC changes will neighter work. SWITCH SCLK back on, when trying to change DAC values\n"
						);

return 0;
}

int get_firmware_revision(){

fd_set ReadFileDescriptor;
int max_fd = 0;
	
int read_return;
unsigned char buffer[984];
unsigned short x,rev;

max_fd = GetMaxFileDescriptor(SOCKETS_PER_FAD, SocketDescriptor);

	cmd_send ("sra 10\n", SocketDescriptor[0]);	
	cmd_send ("t\n", SocketDescriptor[0]);					
	sleep (1);


		FD_ZERO (&ReadFileDescriptor);		
		for (int i = 0; i < SOCKETS_PER_FAD; i++)
		{
			FD_SET (SocketDescriptor[i], &ReadFileDescriptor);
		}

		// Wait for data from sockets
		if (select (((int) max_fd) + 1, &ReadFileDescriptor, NULL, NULL, NULL) == -1)
		{
			perror ("Error with select()\n");
			
		}
		
 
			// Check all sockets
			for (int i = 0; i < SOCKETS_PER_FAD; i++)
			{
				if (FD_ISSET (SocketDescriptor[i], &ReadFileDescriptor))
				{ 
					if ((read_return = read (SocketDescriptor[i], buffer, 984)) == 0)
					{
						printf ("Error: Server not existing anymore, exiting...\n");
						return -1;
					}
					if (read_return > 0)
					{
						printf ("Socket [%d]: Read %d Bytes\n", i, read_return);
					}
				}
			}

	rev = (unsigned char)buffer[4]<<8 | (unsigned char)buffer [5];

return rev;
}

