----------------------------------------------------------------------------------
-- Company:        ETH Zurich, Institute for Particle Physics
-- Engineer:       Q. Weitzel
-- 
-- Create Date:    July 2010 
-- Design Name:    
-- Module Name:    ftu_definitions 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:    library file for FTU design										
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Revision 0.02 - New package "ftu_constants" added, Aug 2010, Q. Weitzel
-- Additional Comments: 
--
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
-- use IEEE.NUMERIC_STD.ALL;

package ftu_array_types is

  --enable signals to switch on/off pixels in trigger (9 pixels per patch)
  type enable_array_type is array (0 to 3) of std_logic_vector(15 downto 0);
  constant DEFAULT_ENABLE : enable_array_type := ("0000000111111111", --patch A
                                                  "0000000111111111", --patch B
                                                  "0000000111111111", --patch C
                                                  "0000000111111111");--patch D

  --DAC values to steer trigger thresholds, 12bit octal DAC, 2.5V reference voltage
  --First 4 values: patches A-D, DACs 5-7 not used, last value: majority coincidence
  type dac_array_type is array (0 to 7) of integer range 0 to 2**12 - 1;
  constant DEFAULT_DAC : dac_array_type := (500, 500, 500, 500, 0, 0, 0, 100);

  --array to hold current values of rate counters (as integers)
  type rate_array_type is array (0 to 4) of integer range 0 to 2**16 - 1;
  
end ftu_array_types;


library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
-- use IEEE.NUMERIC_STD.ALL;

package ftu_constants is

  --internal FPGA clock frequency and rate counter frequency 
  constant INT_CLK_FREQUENCY : integer := 50000000;  -- 50MHz
  constant COUNTER_FREQUENCY : integer :=  1000000;  -- has to be smaller than INT_CLK_FREQUENCY
  constant CNTR_FREQ_DIVIDER : integer :=   500000;  -- for simulation, should normally be 1 
    
  --32byte dual-port RAM, port A: 8byte, port B: 16byte
  constant RAM_ADDR_WIDTH_A : integer := 5;
  constant RAM_ADDR_WIDTH_B : integer := 4;
  constant RAM_ADDR_RATIO   : integer := 2;

  --normalization time for trigger counters
  constant DEFAULT_PRESCALING : integer := 59; --30s integration time

  constant NO_OF_ENABLE       : integer := 4;
  constant NO_OF_DAC          : integer := 8;
  constant NO_OF_DAC_NOT_USED : integer := 3;
  constant NO_OF_COUNTER      : integer := 5;

  --communication with FTM
  constant RS485_BAUD_RATE   : integer := 100000;  -- bits / sec in our case
  constant RS485_BLOCK_WIDTH : integer := 128;     -- 16 byte protocol
  constant RS485_START_DELIM : std_logic_vector(7 downto 0) := "01000000";  -- start delimiter
  constant FTM_ADDRESS       : std_logic_vector(7 downto 0) := "11000000";  -- 192
  
end ftu_constants;
