--
-- VHDL Architecture FACT_FAD_lib.spi_controller.beha
--
-- Created:
--          by - Benjamin Krumm.UNKNOWN (EEPC8)
--          at - 10:37:20 12.04.2010
--
-- using Mentor Graphics HDL Designer(TM) 2009.1 (Build 12)
--
-- modified by Q. Weitzel
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;

ENTITY FTU_spi_controller IS
  PORT( 
    clk          : IN     std_logic;
    mosi         : OUT    std_logic := '0';
    dac_id       : IN     std_logic_vector (2 DOWNTO 0);
    data         : IN  std_logic_vector (15 DOWNTO 0) := (others => '0');
    dac_cs       : OUT    std_logic := '1';
    dac_start    : IN     std_logic;
    dac_ready    : OUT    std_logic := '0'
  );
END FTU_spi_controller ;

ARCHITECTURE beha OF FTU_spi_controller IS
  
  type TYPE_SPI_STATE is (SPI_IDLE, SPI_LOAD_DAC, SPI_LOAD_COMMAND);
   
  signal spi_state     : TYPE_SPI_STATE := SPI_IDLE;
  signal spi_cycle_cnt : integer range 0 to 25 := 0;
  signal shift_reg     : std_logic_vector (23 downto 0) := (others => '0');
  
BEGIN
  
  spi_write_proc: process (clk)
  begin
    if falling_edge(clk) then
      dac_cs <= '1';
      mosi <= '0';
      case spi_state is
        when SPI_IDLE =>
          if (dac_start = '1') then
            dac_ready <= '0';
            spi_state <= SPI_LOAD_COMMAND; 
          end if;
          
        when SPI_LOAD_COMMAND =>
          spi_cycle_cnt <= 0;   
            if (dac_start = '1') then
              shift_reg <= "0011" & '0' & dac_id & data(11 downto 0) & "0000";
              spi_state <= SPI_LOAD_DAC;
            end if;
        
        -- start loading DACs 
       when SPI_LOAD_DAC => 
          dac_cs <= '0';
          if (spi_cycle_cnt < 24) then
            mosi <= shift_reg(23);
            shift_reg <= shift_reg(22 downto 0) & shift_reg(23);
            dac_ready <= '0';
            spi_cycle_cnt <= spi_cycle_cnt + 1;
            spi_state <= SPI_LOAD_DAC;
          else
            dac_cs <= '1';
            dac_ready <= '1';
            spi_state <= SPI_IDLE;
          end if;
      end case;
    end if;
  end process spi_write_proc;
      
END ARCHITECTURE beha;
